/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.store;

import com.wisdom.storalgorithm.element.base.AlleyLabel;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.Policy;
import com.wisdom.storalgorithm.element.base.PolicyFactory;
import com.wisdom.storalgorithm.element.base.Stock;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.element.store.Storage;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Alley
extends Stock {
    private static final Logger LOG = LoggerFactory.getLogger(Alley.class);
    private final List<AlleyLabel> labels = new ArrayList<AlleyLabel>();
    private final List<Cubicle> myCubicle = new ArrayList<Cubicle>();
    private District district;
    private final Set<Group> groups = new HashSet<Group>();
    private Stacker stacker;
    private Storage storage;

    private void init() {
        Arrays.asList(PolicyFactory.values()).stream().forEach(policy -> {
            if (!(policy.policy(this.getDistrict()) instanceof AlleyPolicy)) {
                return;
            }
            this.labels.add(new AlleyLabel(this, (PolicyFactory)((Object)policy)){
                final /* synthetic */ PolicyFactory val$policy;
                {
                    this.val$policy = policyFactory;
                    super(myAlley);
                }

                @Override
                public Policy<CommonParams, Alley> policy() {
                    return this.val$policy.policy(Alley.this.getDistrict());
                }
            });
        });
    }

    public Alley(String id, District district) {
        super(id);
        if (district == null) {
            throw new StatusException("\u5df7\u9053 " + id + " \u7684\u5e93\u533a\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        this.district = district;
        if (!district.getAlleys().contains(this)) {
            district.getAlleys().add(this);
        }
        this.init();
    }

    public CubicleEntry getEntryType() {
        CubicleEntry type = CubicleEntry.no;
        if (this.myCubicle.get(0).getEntryType() != CubicleEntry.no) {
            type = this.myCubicle.get(0).getEntryType();
        }
        if (this.myCubicle.size() > 1 && this.myCubicle.get(this.myCubicle.size() - 1).getEntryType() != CubicleEntry.no) {
            if (type == CubicleEntry.no) {
                type = this.myCubicle.get(this.myCubicle.size() - 1).getEntryType();
            } else {
                return CubicleEntry.both;
            }
        }
        return type;
    }

    public District getDistrict() {
        return this.district;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void addGroup(Group group) {
        if (group.getStacker() != null) {
            this.stacker = group.getStacker();
        }
        this.groups.add(group);
        if (!group.getAllAlleys().contains(this)) {
            group.addAlley(this);
        }
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public List<Cubicle> getMyCubicle() {
        return this.myCubicle;
    }

    public List<AlleyLabel> getLabels() {
        return this.labels;
    }

    public void addMyCubicle(Cubicle cubicle) {
        if (this.myCubicle.size() == 0) {
            this.myCubicle.add(cubicle);
        } else if (this.myCubicle.get(0).getEntryType() == CubicleEntry.no) {
            this.myCubicle.add(0, cubicle);
        } else {
            this.myCubicle.add(cubicle);
        }
    }

    public int allEmptyCubicles() {
        int count;
        for (count = 0; count < this.myCubicle.size() && this.myCubicle.get(count).getMyBracket() == null && this.myCubicle.get(count).getStatus() != StockStatus.forbiden; ++count) {
        }
        return count;
    }

    public Stacker getStacker() {
        return this.stacker;
    }

    @Override
    public void setDepth(int depth) {
        super.setDepth(depth);
        this.myCubicle.stream().forEach(cube -> {
            if (cube.getDepth() == -1) {
                cube.setDepth(depth);
            }
        });
    }

    public boolean areSimilarCargo() {
        List fullCubes = this.myCubicle.stream().filter(cube -> cube.getMyBracket() != null).collect(Collectors.toList());
        for (int i = 1; i < fullCubes.size(); ++i) {
            if (this.myCubicle.get(i - 1).getMyBracket().compatibleWith(this.myCubicle.get(i).getMyBracket())) continue;
            return false;
        }
        return true;
    }

    public void setShelfId(String shelfId) {
        this.myCubicle.stream().forEach(cube -> cube.setShelfId(shelfId));
    }

    public String getShelfId() {
        if (this.myCubicle.size() == 0) {
            return null;
        }
        return this.myCubicle.get(0).getShelfId();
    }

    @Override
    public String toString() {
        return "\u5df7\u9053 " + super.toString();
    }
}

