/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.store;

import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubicleLabel;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.Policy;
import com.wisdom.storalgorithm.element.base.PolicyFactory;
import com.wisdom.storalgorithm.element.base.Stock;
import com.wisdom.storalgorithm.element.base.StockSize;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cubicle
extends Stock {
    private static final Logger LOG = LoggerFactory.getLogger(Cubicle.class);
    private CubicleEntry entryType = CubicleEntry.no;
    private Alley myAlley = null;
    private String shelfId;
    private Bracket myBracket = null;
    private int x;
    private int y;
    private int floor;
    private double fx;
    private double fy;
    private double fz;
    private final List<CubicleLabel> labels = new ArrayList<CubicleLabel>();

    private void init() {
        Arrays.asList(PolicyFactory.values()).stream().forEach(policy -> {
            if (!(policy.policy(this.getMyAlley().getDistrict()) instanceof CubiclePolicy)) {
                return;
            }
            this.labels.add(new CubicleLabel(this, (PolicyFactory)((Object)policy)){
                final /* synthetic */ PolicyFactory val$policy;
                {
                    this.val$policy = policyFactory;
                    super(myCubicle);
                }

                @Override
                public Policy<CommonParams, Cubicle> policy() {
                    return this.val$policy.policy(Cubicle.this.getMyAlley().getDistrict());
                }
            });
        });
    }

    public Cubicle(String id, Alley myAlley, CubicleEntry entryType, int x, int y, int z) {
        super(id);
        if (myAlley == null) {
            throw new StatusException("\u5e93\u4f4d " + id + " \u7684\u5df7\u9053\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        this.myAlley = myAlley;
        if (!myAlley.getMyCubicle().contains(this)) {
            myAlley.addMyCubicle(this);
            if (LOG.isTraceEnabled()) {
                LOG.trace(myAlley + " \u6dfb\u52a0\u5bf9\u5e94 " + this);
            }
        }
        this.init();
        this.entryType = entryType;
        this.x = x;
        this.y = y;
        this.floor = z;
    }

    public Cubicle(String id, Alley myAlley, CubicleEntry entryType, int x, int y, int z, StockSize size) {
        this(id, myAlley, entryType, x, y, z);
        if (size == null || size == StockSize.Undefined) {
            throw new StatusException("\u5e93\u4f4d\u5c3a\u5bf8\u4e0d\u80fd\u5b9a\u4e49\u4e3a\uff1a" + (Object)((Object)size));
        }
        this.size = size;
    }

    public CubicleEntry getEntryType() {
        return this.entryType;
    }

    public void setEntryType(CubicleEntry entryType) {
        this.entryType = entryType;
    }

    public void setBracket(Bracket bracket) throws StatusException {
        this.myBracket = bracket;
        if (bracket != null && bracket.getLocation() != this) {
            bracket.setLocation(this);
        }
        if (this.getStatus() != StockStatus.empty && this.getStatus() != StockStatus.full) {
            return;
        }
        if (this.myBracket == null) {
            super.setStatus(StockStatus.empty);
        } else {
            super.setStatus(StockStatus.full);
        }
    }

    public Alley getMyAlley() {
        return this.myAlley;
    }

    public String getShelfId() {
        return this.shelfId;
    }

    public void setShelfId(String shelfId) {
        this.shelfId = shelfId;
    }

    public Bracket getMyBracket() {
        return this.myBracket;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getFloor() {
        return this.floor;
    }

    public void setFloor(int floor) {
        this.floor = floor;
    }

    public double getFx() {
        return this.fx;
    }

    public double getFy() {
        return this.fy;
    }

    public double getFz() {
        return this.fz;
    }

    public List<CubicleLabel> getLabels() {
        return this.labels;
    }

    @Override
    public void setDepth(int depth) {
        super.setDepth(depth);
        if (this.getMyAlley().getDepth() == -1) {
            this.getMyAlley().setDepth(depth);
        }
    }

    @Override
    public void setStatus(StockStatus status) {
        if (status == StockStatus.empty || status == StockStatus.full) {
            return;
        }
        super.setStatus(status);
    }

    public void resetStatus() {
        if (this.myBracket == null) {
            super.setStatus(StockStatus.empty);
        } else {
            super.setStatus(StockStatus.full);
        }
    }

    protected String mapStatus() {
        switch (this.getStatus()) {
            case empty: {
                if (this.getMyBracket() == null) {
                    return this.getStatus().toString();
                }
                return "\u4e34\u65f6\u7a7a\u5e93";
            }
            case full: {
                if (this.getMyBracket() == null) {
                    return "\u4e0d\u4e00\u81f4\u6ee1\u5e93";
                }
                return this.getStatus().toString();
            }
        }
        return this.getStatus().toString();
    }

    @Override
    public String toString() {
        return "\u5e93\u4f4d " + super.toString() + ", " + (Object)((Object)this.entryType) + ", " + this.mapStatus();
    }
}

