/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.store;

import com.wisdom.storalgorithm.element.base.Car;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.Stock;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.car.Shuttle;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.element.store.Lift;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class District
extends Stock {
    private static final Logger LOG = LoggerFactory.getLogger(District.class);
    private int length = -1;
    private int height = -1;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxZ = Integer.MIN_VALUE;
    private final List<Group> groups = new ArrayList<Group>();
    private final Set<Alley> alleys = new HashSet<Alley>();
    private final List<Car> cars = new ArrayList<Car>();
    private int[] emptyCubesNum = null;
    private int[] totalCubesNum = null;
    private Cubicle[] cubicles = null;
    private final Map<Integer, Integer> leaveMovableEmpties = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> movableEmpties = new HashMap<Integer, Integer>();
    private final Map<String, Lift> lifts = new HashMap<String, Lift>();
    private int maxCubeNumberInAlley = 0;

    public District(String id) {
        super(id);
    }

    public boolean isStacker() {
        if (this.cars.size() == 0) {
            return false;
        }
        return this.cars.get(0) instanceof Stacker;
    }

    public boolean isShuttle() {
        if (this.cars.size() == 0) {
            return false;
        }
        return this.cars.get(0) instanceof Shuttle;
    }

    public StockType getCarType() {
        if (this.isStacker()) {
            return StockType.STACKER;
        }
        if (this.isShuttle()) {
            return StockType.SHUTTLE;
        }
        return StockType.UNKNOWN;
    }

    public Set<Alley> getAlleys() {
        return this.alleys;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Car> getCars() {
        return this.cars;
    }

    public void addCar(Car car) {
        if (this.cars.size() > 0 && this.cars.get(0).getClass() != car.getClass()) {
            throw new StatusException("\u5e93\u533a\u5185\u6dfb\u52a0\u7684\u8f66\u8f86\u5c5e\u6027\u9519\u8bef\uff01");
        }
        this.cars.add(car);
    }

    public void addAlley(Alley alley) {
        this.alleys.add(alley);
    }

    public void addGroup(Group group) {
        this.groups.add(group);
        if (group.getStacker() != null) {
            this.addCar(group.getStacker());
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " \u6dfb\u52a0\u5bf9\u5e94 " + group.getStacker());
            }
        }
    }

    public int getLength() {
        if (this.length < 0) {
            this.countTotalCubes();
        }
        return this.length;
    }

    @Override
    public int getDepth() {
        if (this.depth < 0) {
            this.countTotalCubes();
        }
        return this.depth;
    }

    public int getHeight() {
        if (this.height < 0) {
            this.countTotalCubes();
        }
        return this.height;
    }

    public int getMinX() {
        if (this.minX == Integer.MAX_VALUE) {
            this.countTotalCubes();
        }
        return this.minX;
    }

    public int getMaxX() {
        if (this.maxX == Integer.MIN_VALUE) {
            this.countTotalCubes();
        }
        return this.maxX;
    }

    public int getMinY() {
        if (this.minY == Integer.MAX_VALUE) {
            this.countTotalCubes();
        }
        return this.minY;
    }

    public int getMaxY() {
        if (this.maxY == Integer.MIN_VALUE) {
            this.countTotalCubes();
        }
        return this.maxY;
    }

    public int getMinZ() {
        if (this.minZ == Integer.MAX_VALUE) {
            this.countTotalCubes();
        }
        return this.minZ;
    }

    public int getMaxZ() {
        if (this.maxZ == Integer.MIN_VALUE) {
            this.countTotalCubes();
        }
        return this.maxZ;
    }

    public int getMaxCubeNumberInAlley() {
        return this.maxCubeNumberInAlley;
    }

    private int mapValue(int x, int y, int floor) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u8bfb\u53d6\u6620\u5c04\u5e93\u4f4d\uff1a" + x + ", " + y + ", " + floor);
        }
        return (floor - this.minZ) * this.length * this.depth + (y - this.minY) * this.length + (x - this.minX);
    }

    public Cubicle getCubicle(int x, int y, int floor) {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        return this.cubicles[this.mapValue(x, y, floor)];
    }

    public Cubicle[] getCubicles() {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        return this.cubicles;
    }

    public void initCubicleSteps() {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        IntStream.range(0, this.cubicles.length).forEach(i -> {
            if (this.cubicles[i] == null) {
                return;
            }
            this.cubicles[i].setDistanceSteps(10);
        });
    }

    private void calculateSize() {
        Cubicle tmpCubicle;
        int j;
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " \u5f00\u59cb\u8ba1\u7b97\u5e93\u4f4d\u5750\u6807\u62d3\u6251\u4fe1\u606f\u3002");
        }
        for (Alley alley : this.alleys) {
            for (j = 0; j < alley.getMyCubicle().size(); ++j) {
                tmpCubicle = alley.getMyCubicle().get(j);
                if (this.minX > tmpCubicle.getX()) {
                    this.minX = tmpCubicle.getX();
                }
                if (this.maxX < tmpCubicle.getX()) {
                    this.maxX = tmpCubicle.getX();
                }
                if (this.minY > tmpCubicle.getY()) {
                    this.minY = tmpCubicle.getY();
                }
                if (this.maxY < tmpCubicle.getY()) {
                    this.maxY = tmpCubicle.getY();
                }
                if (this.minZ > tmpCubicle.getFloor()) {
                    this.minZ = tmpCubicle.getFloor();
                }
                if (this.maxZ >= tmpCubicle.getFloor()) continue;
                this.maxZ = tmpCubicle.getFloor();
            }
        }
        if (this.minX != Integer.MAX_VALUE && this.maxX != Integer.MIN_VALUE) {
            this.length = this.maxX - this.minX + 1;
        }
        if (this.minY != Integer.MAX_VALUE && this.maxY != Integer.MIN_VALUE) {
            this.depth = this.maxY - this.minY + 1;
        }
        if (this.minZ != Integer.MAX_VALUE && this.maxZ != Integer.MIN_VALUE) {
            this.height = this.maxZ - this.minZ + 1;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u8ba1\u7b97\u83b7\u5f97\u5e93\u533a " + this + " \u7684\u5e93\u4f4d\u4fe1\u606f\uff0cx\u6700\u5c0f\u503c\uff1a" + this.minX + ", x\u6700\u5927\u503c\uff1a" + this.maxX + ", y\u6700\u5c0f\u503c\uff1a" + this.minY + ", y\u6700\u5927\u503c\uff1a" + this.maxY + ", z\u6700\u5c0f\u503c\uff1a" + this.minZ + ", z\u6700\u5927\u503c\uff1a" + this.maxZ + ", \u5e93\u533a\u957f\u5ea6\uff1a" + this.length + ", \u5e93\u533a\u6df1\u5ea6\uff1a" + this.depth + ", \u5e93\u533a\u697c\u5c42\u6570\uff1a" + this.height);
        }
        this.maxCubeNumberInAlley = 0;
        this.cubicles = new Cubicle[this.length * this.depth * this.height];
        for (Alley alley : this.alleys) {
            for (j = 0; j < alley.getMyCubicle().size(); ++j) {
                this.cubicles[this.mapValue((int)tmpCubicle.getX(), (int)tmpCubicle.getY(), (int)tmpCubicle.getFloor())] = tmpCubicle = alley.getMyCubicle().get(j);
            }
            if (alley.getMyCubicle().size() <= this.maxCubeNumberInAlley) continue;
            this.maxCubeNumberInAlley = alley.getMyCubicle().size();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " \u7ed3\u675f\u8ba1\u7b97\u5e93\u4f4d\u5750\u6807\u62d3\u6251\u4fe1\u606f\u3002");
        }
    }

    public int getEmptyCubeNumber(int id) {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        if (this.isShuttle()) {
            int i = id - this.minZ;
            if (i < 0 || i >= this.emptyCubesNum.length) {
                throw new StatusException("\u4e0d\u5b58\u5728\u7684\u697c\u5c42" + id + "\uff01");
            }
            return this.emptyCubesNum[i];
        }
        if (this.isStacker()) {
            if (id < 0 || id >= this.emptyCubesNum.length) {
                throw new StatusException("\u4e0d\u5b58\u5728\u7684\u5806\u579b\u673a\u7f16\u53f7" + id + "\uff01");
            }
            return this.emptyCubesNum[id];
        }
        return -1;
    }

    public void countEmptyCubes() {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        boolean isShuttle = this.isShuttle();
        boolean isStacker = this.isStacker();
        HashMap<Car, Integer> tmpCars = new HashMap<Car, Integer>();
        if (isShuttle) {
            this.emptyCubesNum = new int[this.height];
        } else if (isStacker) {
            this.emptyCubesNum = new int[this.cars.size()];
            for (int i = 0; i < this.cars.size(); ++i) {
                tmpCars.put(this.cars.get(i), i);
            }
        }
        Arrays.asList(this.cubicles).stream().forEach(cube -> {
            if (cube == null || cube.getStatus() != StockStatus.empty) {
                return;
            }
            if (isShuttle) {
                int n = cube.getFloor() - this.minZ;
                this.emptyCubesNum[n] = this.emptyCubesNum[n] + 1;
            } else if (isStacker) {
                Integer id = (Integer)tmpCars.get(cube.getMyAlley().getStacker());
                if (id == null) {
                    return;
                }
                int n = id;
                this.emptyCubesNum[n] = this.emptyCubesNum[n] + 1;
            }
        });
    }

    public int getTotalCubeNumber(int id) {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        if (this.isShuttle()) {
            int i = id - this.minZ;
            if (i < 0 || i >= this.totalCubesNum.length) {
                throw new StatusException("\u4e0d\u5b58\u5728\u7684\u697c\u5c42" + id + "\uff01");
            }
            return this.totalCubesNum[i];
        }
        if (this.isStacker()) {
            if (id < 0 || id >= this.totalCubesNum.length) {
                throw new StatusException("\u4e0d\u5b58\u5728\u7684\u5806\u579b\u673a\u7f16\u53f7" + id + "\uff01");
            }
            return this.totalCubesNum[id];
        }
        return -1;
    }

    private void countTotalCubes() {
        this.calculateSize();
        if (this.isShuttle()) {
            this.totalCubesNum = new int[this.height];
            this.alleys.stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> {
                int n = cube.getFloor() - this.minZ;
                this.totalCubesNum[n] = this.totalCubesNum[n] + 1;
            }));
        } else if (this.isStacker()) {
            this.totalCubesNum = new int[this.cars.size()];
            for (int i = 0; i < this.cars.size(); ++i) {
                int tmpi = i;
                ((Stacker)this.cars.get(i)).getMyGroup().getAllAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> {
                    int n = tmpi;
                    this.totalCubesNum[n] = this.totalCubesNum[n] + 1;
                }));
            }
        }
    }

    public int getLeaveMovableEmptyNumber(int floor) {
        Integer ret = this.leaveMovableEmpties.get(floor);
        if (ret == null || ret < 0) {
            return StorageConst.MinEmptyNumber;
        }
        return ret;
    }

    public void setLeaveMovableEmptyNumber(int floor, int num) {
        if (this.cubicles == null) {
            this.countTotalCubes();
        }
        if (floor - this.minZ >= this.height) {
            LOG.error("\u672c\u5e93\u533a " + this.getId() + " \u4e0d\u5305\u542b " + floor + " \u8fd9\u4e2a\u697c\u5c42\uff01");
            return;
        }
        this.leaveMovableEmpties.put(floor, num);
    }

    public int getMovableEmptyNumber(int floor) {
        Integer ret = this.movableEmpties.get(floor);
        if (ret == null || ret < 0) {
            return -1;
        }
        return ret;
    }

    public void calculateMovableEmptyCubes() {
        if (this.isStacker()) {
            return;
        }
        this.movableEmpties.clear();
        this.getAlleys().stream().forEach(alley -> {
            if (alley.getMyCubicle().isEmpty()) {
                LOG.error("\u5df7\u9053 " + alley.getId() + " \u4e3a\u975e\u6cd5\u7684\u65e0\u5e93\u4f4d\u5df7\u9053\uff01");
                return;
            }
            int floor = alley.getMyCubicle().get(0).getFloor();
            Integer num = this.movableEmpties.get(floor);
            if (num == null) {
                num = 0;
            }
            int leftEmpties = this.leftEmpties((Alley)alley);
            num = num + leftEmpties;
            if (leftEmpties < alley.getMyCubicle().size()) {
                num = num + this.rightEmpties((Alley)alley);
            }
            this.movableEmpties.put(floor, num);
        });
    }

    private int leftEmpties(Alley alley) {
        int ret = 0;
        for (Cubicle cube : alley.getMyCubicle()) {
            if (cube.getMyBracket() != null || cube.getStatus() == StockStatus.forbiden || cube.getStatus() == StockStatus.locked_in) break;
            ++ret;
        }
        return ret;
    }

    private int rightEmpties(Alley alley) {
        Cubicle cube;
        int ret = 0;
        if (alley.getMyCubicle().get(alley.getMyCubicle().size() - 1).getEntryType() == CubicleEntry.no) {
            return ret;
        }
        for (int i = alley.getMyCubicle().size() - 1; i >= 0 && (cube = alley.getMyCubicle().get(i)).getMyBracket() == null && cube.getStatus() != StockStatus.forbiden && cube.getStatus() != StockStatus.locked_in; --i) {
            ++ret;
        }
        return ret;
    }

    public Lift getLift(String id) {
        Lift ret = this.lifts.get(id);
        if (ret == null) {
            ret = new Lift(id);
            this.lifts.put(id, ret);
        }
        return ret;
    }

    @Override
    public String toString() {
        return "\u5e93\u533a " + super.toString() + (this.isShuttle() ? "\u7a7f\u68ad\u8f66\u5e93" : (this.isStacker() ? "\u5806\u579b\u673a\u5e93" : "\u672a\u77e5\u5e93"));
    }
}

