/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.store;

import com.wisdom.storalgorithm.element.base.Stock;
import com.wisdom.storalgorithm.element.base.StockSize;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.District;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group
extends Stock {
    private static final Logger LOG = LoggerFactory.getLogger(Group.class);
    private Stacker stacker = null;
    private Map<StockSize, Integer> emptyNumber = new HashMap<StockSize, Integer>();
    private final Set<Alley> alleys = new HashSet<Alley>();
    private District myDistrict = null;

    public Group(String id) {
        super(id);
    }

    public Stacker getStacker() {
        return this.stacker;
    }

    public void setStacker(Stacker stacker) {
        this.stacker = stacker;
        if (stacker.getMyGroup() == null) {
            stacker.setMyGroup(this);
            LOG.info(stacker + " \u6dfb\u52a0\u5bf9\u5e94 " + this);
        }
    }

    public void addAlley(Alley alley) {
        if (this.alleys.contains(alley)) {
            return;
        }
        this.alleys.add(alley);
        if (!alley.getGroups().contains(this)) {
            alley.addGroup(this);
            LOG.info(alley + " \u6dfb\u52a0\u5bf9\u5e94 " + this);
        }
    }

    public Set<Alley> getAllAlleys() {
        return this.alleys;
    }

    public District getMyDistrict() {
        return this.myDistrict;
    }

    public void setMyDistrict(District myDistrict) {
        this.myDistrict = myDistrict;
    }

    public int getEmptyNumber(StockSize size) {
        Integer ret = this.emptyNumber.get((Object)size);
        if (ret == null) {
            ret = 0;
        }
        return ret;
    }

    public int getEmptyNumber() {
        return this.getEmptyNumber(StockSize.Normal);
    }

    public void setEmptyNumber(StockSize size, int emptyNumber) {
        this.emptyNumber.put(size, emptyNumber);
        LOG.info(this + " " + (Object)((Object)size) + " \u7684\u7a7a\u5e93\u4f4d\u6570\u4e3a " + emptyNumber);
    }

    public void setEmptyNumber(int emptyNumber) {
        this.setEmptyNumber(StockSize.Normal, emptyNumber);
    }

    @Override
    public String toString() {
        return "\u5206\u7ec4 " + super.toString();
    }
}

