/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.element.store;

import com.wisdom.storalgorithm.element.base.Stock;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lift
extends Stock {
    private static final Logger LOG = LoggerFactory.getLogger(Lift.class);
    private final List<Integer> buff = new ArrayList<Integer>();
    private final List<Bracket> waitingBrackets = new ArrayList<Bracket>();

    public Lift(String id) {
        super(id);
    }

    public void setBufferNumber(int floor, int num) {
        if (num < 1) {
            LOG.error("\u5f53\u524d\u697c\u5c42 " + floor + " \u6240\u8bbe\u7f6e\u7684\u7f13\u51b2\u4f4d\u7f6e\u6570\u91cf " + num + " \u4e3a\u65e0\u6548\u503c\uff01");
            return;
        }
        if (this.buff.size() <= floor) {
            int count = floor + 1 - this.buff.size();
            for (int i = 0; i < count; ++i) {
                this.buff.add(StorageConst.DefaultBufferNumber);
            }
        }
        if (num < StorageConst.DefaultBufferNumber) {
            LOG.warn("\u5f53\u524d\u697c\u5c42 " + floor + " \u6240\u8bbe\u7f6e\u7684\u7f13\u51b2\u4f4d\u7f6e\u6570\u91cf " + num + " \u5c0f\u4e8e\u6bcf\u5c42\u9ed8\u8ba4\u6570\u91cf " + StorageConst.DefaultBufferNumber);
        }
        this.buff.set(floor, num);
    }

    public int getBufferNumber(int floor) {
        if (this.buff.size() <= floor) {
            LOG.warn("\u5f53\u524d\u697c\u5c42 " + floor + " \u672a\u8bbe\u7f6e\u7f13\u51b2\u4f4d\u7f6e\u6570\u91cf \uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c " + StorageConst.DefaultBufferNumber);
            return StorageConst.DefaultBufferNumber;
        }
        return this.buff.get(floor);
    }

    public void clearWaitingBrackets() {
        this.waitingBrackets.clear();
    }

    public void addWaitingBracket(Bracket bracket) {
        this.waitingBrackets.add(bracket);
        bracket.setLift(this);
    }

    public List<Bracket> getWaitingBrackets() {
        return this.waitingBrackets;
    }
}

