/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentStock
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentStock.class);

    public FragmentStock(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
        this.setTopLevel(0);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        if (this.isBlocked(myCubicle)) {
            if (this.getMode() == AlgorithomMode.UNIFORM) {
                return this.excludedXValue();
            }
            return this.availableMaxXValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myCubicle);
            }
        }
        return this.moveIn(commonParams, myCubicle);
    }

    private boolean isBlocked(Cubicle myCubicle) {
        int i;
        List<Cubicle> myAlleyCubes = myCubicle.getMyAlley().getMyCubicle();
        if (myAlleyCubes.get(0).getEntryType() != CubicleEntry.no) {
            for (i = 0; i < myAlleyCubes.size(); ++i) {
                if (myCubicle == myAlleyCubes.get(i)) {
                    return false;
                }
                if (myAlleyCubes.get(i).getStatus() != StockStatus.empty && myAlleyCubes.get(i).getStatus() != StockStatus.locked_out) break;
            }
        }
        if (myAlleyCubes.get(myAlleyCubes.size() - 1).getEntryType() != CubicleEntry.no) {
            for (i = myAlleyCubes.size() - 1; i >= 0; --i) {
                if (myCubicle == myAlleyCubes.get(i)) {
                    return false;
                }
                if (myAlleyCubes.get(i).getStatus() != StockStatus.empty && myAlleyCubes.get(i).getStatus() != StockStatus.locked_out) break;
            }
        }
        return true;
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        Iterator<Cubicle> iterator;
        if (myCubicle.getStatus() != StockStatus.empty) {
            return this.excludedXValue();
        }
        Set<Cubicle> simCubes = commonParams.getSimilarCubicles();
        if (myCubicle.getMyAlley().getMyCubicle().stream().anyMatch(cubicle -> simCubes.contains(cubicle)) && (iterator = myCubicle.getMyAlley().getMyCubicle().iterator()).hasNext()) {
            Cubicle cubicle2 = iterator.next();
            if (cubicle2.getStatus() == StockStatus.locked_out) {
                return this.excludedXValue();
            }
            return this.getMappedValue(0.0);
        }
        if (this.getMode() == AlgorithomMode.UNIFORM) {
            return this.availableMaxXValue();
        }
        if (this.getMode() == AlgorithomMode.SUGGEST) {
            return this.getMappedValue(0.5);
        }
        return this.ignoreValue();
    }

    private double moveOut(CommonParams commonParams, Cubicle myCubicle) {
        if (myCubicle.getStatus() == StockStatus.empty) {
            return this.excludedXValue();
        }
        long leftCount = myCubicle.getMyAlley().getMyCubicle().stream().filter(cube -> cube.getStatus() != StockStatus.empty).filter(cube -> cube.getMyBracket() != null).filter(cube -> cube.getMyBracket().equals(commonParams.getNewBracket())).filter(cube -> cube.getStatus() != StockStatus.locked_out).count();
        if (leftCount == 0L) {
            LOG.warn("\u4e0d\u5e94\u8be5\u5728\u68c0\u6d4b\u5e93\u4f4d" + myCubicle.getId() + "\u7684\u65f6\u5019\u53d1\u73b0\u7a7a\u5df7\u9053\uff01");
            return this.excludedXValue();
        }
        if (leftCount == (long)myCubicle.getMyAlley().getMyCubicle().size()) {
            return this.getMappedValue(1.0);
        }
        return this.getMappedValue(leftCount - 1L, 0.0, (double)(myCubicle.getMyAlley().getMyCubicle().size() - 1));
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }
}

