/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Inside2Outside
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(Inside2Outside.class);

    public Inside2Outside(String name) {
        super(name);
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(myAlley);
            }
        }
        return this.moveIn(myAlley);
    }

    private double moveIn(Alley myAlley) {
        int maxDepth = myAlley.getDistrict().getDepth();
        if (myAlley.getDistrict().isStacker()) {
            return this.getMappedValue(myAlley.getDepth(), 0, maxDepth);
        }
        return this.getMappedValue(maxDepth - myAlley.getDepth(), 0, maxDepth);
    }

    private double moveOut(Alley myAlley) {
        int maxDepth = myAlley.getDistrict().getDepth();
        return this.getMappedValue(maxDepth - myAlley.getDepth(), 0, maxDepth);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }
}

