/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalFirst
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(InternalFirst.class);
    public static final int MAXCUBEINALLEY = 2;

    public InternalFirst(String name) {
        super(name);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(myCubicle);
            }
        }
        return this.moveIn(myCubicle);
    }

    private double moveIn(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        for (int i = 0; i < myAlley.getMyCubicle().size(); ++i) {
            if (myAlley.getMyCubicle().get(i) != myCubicle) continue;
            return this.getMappedValue(2 - i - 1, 0, 2);
        }
        return this.excludedXValue();
    }

    private double moveOut(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        boolean stucked = false;
        for (int i = 0; i < myAlley.getMyCubicle().size(); ++i) {
            Cubicle tmpCubicle = myAlley.getMyCubicle().get(i);
            if (tmpCubicle == myCubicle) {
                if (stucked) {
                    LOG.debug(myCubicle + "\u51fa\u53e3\u88ab\u5835\u4e86\uff0c\u6b64\u8d27\u65e0\u6cd5\u51fa\u53bb");
                    return this.excludedXValue();
                }
                return this.getMappedValue(0.0);
            }
            stucked = stucked || tmpCubicle.getStatus() != StockStatus.empty && tmpCubicle.getStatus() != StockStatus.locked_out;
        }
        LOG.warn("\u6b64\u5904\u4e0d\u5e94\u8be5\u53d1\u751f " + myCubicle.getId());
        return this.excludedXValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }
}

