/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.Lift;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiftBuffer
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(LiftBuffer.class);

    public LiftBuffer(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myAlley);
            }
        }
        return this.ignoreValue();
    }

    private int headBracketNumber(Lift lift, int myFloor, Bracket myBracket) {
        List<Bracket> waitingBrackets = lift.getWaitingBrackets();
        int ret = 0;
        for (int i = 0; i < waitingBrackets.size(); ++i) {
            Cubicle cube = waitingBrackets.get(i).getLocation();
            if (cube == null) {
                LOG.warn("\u5347\u964d\u673a " + lift + " \u4f20\u9001\u5e26\u5185\u53d1\u73b0\u4e00\u4e2a\u6ca1\u5b9a\u4e49\u5e93\u4f4d\u7684\u8d27\u7269 " + waitingBrackets.get(i));
                continue;
            }
            if (cube.getFloor() != myFloor) continue;
            ++ret;
        }
        return ret;
    }

    private boolean previousIsSameFloor(Lift lift, int myFloor) {
        List<Bracket> waitingBrackets = lift.getWaitingBrackets();
        if (waitingBrackets.isEmpty()) {
            return false;
        }
        Bracket bracket = waitingBrackets.get(waitingBrackets.size() - 1);
        Cubicle cube = bracket.getLocation();
        if (cube == null) {
            LOG.warn("\u5347\u964d\u673a " + lift + " \u4f20\u9001\u5e26\u5185\u53d1\u73b0\u4e00\u4e2a\u6ca1\u5b9a\u4e49\u5e93\u4f4d\u7684\u8d27\u7269 " + bracket);
            return false;
        }
        return cube.getFloor() == myFloor;
    }

    private double moveIn(CommonParams commonParams, Alley myAlley) {
        Bracket myBracket = commonParams.getNewBracket();
        if (myBracket == null) {
            LOG.error("\u8fd9\u662f\u4e2a\u975e\u6cd5\u7684\u5165\u5e93\u53c2\u6570 " + commonParams);
            return this.excludedXValue();
        }
        Lift myLift = myBracket.getLift();
        if (myLift == null) {
            return this.ignoreValue();
        }
        int myFloor = myAlley.getMyCubicle().get(0).getFloor();
        int occupiedNum = this.headBracketNumber(myLift, myFloor, myBracket);
        int myBufferNum = myLift.getBufferNumber(myFloor);
        if (this.previousIsSameFloor(myLift, myFloor)) {
            return this.getMappedValue(1.0);
        }
        if (occupiedNum >= myBufferNum) {
            return this.getMappedValue(0.5);
        }
        return this.ignoreValue();
    }
}

