/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackNumber
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PackNumber.class);

    public PackNumber(String name) {
        super(name);
        this.setMode(AlgorithomMode.ALGORITHOM1);
    }

    @Override
    public void setMode(AlgorithomMode mode) {
        super.setMode(mode);
        switch (mode) {
            case ALGORITHOM2: 
            case ALGORITHOM1: {
                this.setTopLevel(0);
            }
        }
        this.setDefaultLevel();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myCubicle);
            }
        }
        return this.moveIn(commonParams, myCubicle);
    }

    private double moveIn(CommonParams params, Cubicle myCubicle) {
        return this.ignoreValue();
    }

    private double moveOut(CommonParams params, Cubicle myCubicle) {
        if (params.getMaxPackNumber() <= 0) {
            return this.ignoreValue();
        }
        try {
            String packNum = myCubicle.getMyBracket().get("\u8d27\u54c1\u4ef6\u6570");
            if (packNum == null || packNum.isEmpty()) {
                LOG.error("\u8d27\u4f4d " + myCubicle.getId() + " \u6240\u653e\u8d27\u7269 " + myCubicle.getMyBracket() + " \u4e0d\u542b\u8d27\u7269\u4ef6\u6570\uff01");
                return this.excludedXValue();
            }
            int packN = Integer.valueOf(packNum);
            if (packN <= 0) {
                LOG.error("\u8d27\u4f4d " + myCubicle.getId() + " \u6240\u653e\u8d27\u7269 " + myCubicle.getMyBracket() + " \u4e0d\u542b\u8d27\u7269\u4ef6\u6570\uff01\uff01");
                return this.excludedXValue();
            }
            switch (this.mode) {
                case ALGORITHOM2: {
                    return this.getMappedValue(params.getMaxPackNumber() - packN, 0, params.getMaxPackNumber());
                }
                case ALGORITHOM1: {
                    return this.getMappedValue(packN - 1, 0, params.getMaxPackNumber());
                }
            }
            return this.ignoreValue();
        }
        catch (Exception e) {
            LOG.error(myCubicle + " PackNumber \u51fa\u9519", (Throwable)e);
            return this.ignoreValue();
        }
    }
}

