/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFloorOrder
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyFloorOrder.class);

    public PolicyFloorOrder(String name) {
        super(name);
        this.setMode(AlgorithomMode.ALGORITHOM1);
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myAlley);
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        int floor = myAlley.getMyCubicle().get(0).getFloor();
        if (myAlley.getDistrict().isShuttle() && this.mode == AlgorithomMode.ALGORITHOM1) {
            int emptyNum = myAlley.getDistrict().getEmptyCubeNumber(floor);
            int totalNum = myAlley.getDistrict().getTotalCubeNumber(floor);
            return this.getMappedValue(totalNum - emptyNum, 0, totalNum);
        }
        int maxFloor = myAlley.getDistrict().getHeight();
        return this.getMappedValue(floor, 0, maxFloor);
    }

    private double moveOut(CommonParams params, Alley myAlley) {
        int floor = myAlley.getMyCubicle().get(0).getFloor();
        if (myAlley.getDistrict().isShuttle() && this.mode == AlgorithomMode.ALGORITHOM1) {
            int emptyNum = myAlley.getDistrict().getEmptyCubeNumber(floor);
            int totalNum = myAlley.getDistrict().getTotalCubeNumber(floor);
            return this.getMappedValue(emptyNum, 0, totalNum);
        }
        int maxFloor = myAlley.getDistrict().getHeight();
        return this.getMappedValue(maxFloor - floor, 0, maxFloor);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }
}

