/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyFloorSelection
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyFloorSelection.class);

    public PolicyFloorSelection(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myAlley);
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams commonParams, Alley myAlley) {
        int totalShuttleNum = myAlley.getDistrict().getCars().size();
        long shuttleNumOnMyFloor = myAlley.getDistrict().getCars().stream().filter(shuttle -> shuttle.position()[2] == myAlley.getMyCubicle().get(0).getFloor()).count();
        return this.getMappedValue((long)totalShuttleNum - shuttleNumOnMyFloor, 0.0, (double)totalShuttleNum);
    }

    private double moveOut(CommonParams commonParams, Alley myAlley) {
        return this.ignoreValue();
    }
}

