/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CarStatus;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyForbidStore
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyForbidStore.class);

    public PolicyForbidStore(String name) {
        super(name);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(myCubicle);
            }
        }
        return this.moveIn(myCubicle);
    }

    private double moveIn(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        if (myCubicle.getMyBracket() != null || myCubicle.getStatus() != StockStatus.empty || myAlley.getStatus() != StockStatus.empty || myAlley.getDistrict().getStatus() != StockStatus.empty) {
            LOG.debug(myCubicle + " \u88ab\u7981\u7528\u5165\u5e93\u3002");
            return this.excludedXValue();
        }
        if (myAlley.getGroups().stream().anyMatch(group -> group.getStatus() != StockStatus.empty || group.getStacker() != null && (group.getStacker().getStatus() == CarStatus.fault || group.getStacker().getStatus() == CarStatus.putout))) {
            LOG.debug(myAlley + " \u6709\u6240\u5c5e\u5206\u7ec4\u65e0\u6cd5\u6b63\u5e38\u5165\u5e93\u5de5\u4f5c\u3002");
            return this.excludedXValue();
        }
        return this.getMappedValue(0.0);
    }

    private double moveOut(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        if (myCubicle.getMyBracket() == null || myCubicle.getStatus() != StockStatus.full) {
            LOG.debug(myCubicle + " \u88ab\u7981\u7528\u51fa\u5e93\u3002");
            return this.excludedXValue();
        }
        if (myAlley.getGroups().stream().anyMatch(group -> group.getStatus() == StockStatus.forbiden || group.getStacker() != null && (group.getStacker().getStatus() == CarStatus.fault || group.getStacker().getStatus() == CarStatus.putin))) {
            LOG.debug(myAlley + " \u6709\u6240\u5c5e\u5206\u7ec4\u65e0\u6cd5\u6b63\u5e38\u51fa\u5e93\u5de5\u4f5c\u3002");
            return this.excludedXValue();
        }
        return this.getMappedValue(0.0);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }
}

