/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyGroups
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyGroups.class);

    public PolicyGroups(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
        this.setTopLevel(0);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }

    @Override
    public double x(CommonParams params, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        return this.move(params, myAlley);
    }

    private double move(CommonParams commonParams, Alley myAlley) {
        if (commonParams.getGroups().size() == 0) {
            return this.ignoreValue();
        }
        int iAmInGroupList = myAlley.getGroups().stream().map(group -> commonParams.isInGroups((Group)group)).min(Comparator.comparing(x -> x)).orElse(Integer.MAX_VALUE);
        if (iAmInGroupList == Integer.MAX_VALUE) {
            if (this.getMode() == AlgorithomMode.UNIFORM) {
                LOG.debug(myAlley + "\u6240\u5c5e\u5806\u579b\u673a\uff0c\u4e0d\u5728\u6307\u5b9a\u7684\u5806\u579b\u673a\u5217\u8868\u5185\u3002\u5728\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4\u7684\u539f\u5219\u4e0b\uff0c\u5254\u9664\u6b64\u5e93\u4f4d\u3002");
                return this.excludedXValue();
            }
            LOG.debug(myAlley + "\u6240\u5c5e\u5806\u579b\u673a\uff0c\u4e0d\u5728\u6307\u5b9a\u7684\u5806\u579b\u673a\u5217\u8868\u5185\u3002\u5efa\u8bae\u4e0d\u9009\u62e9\u6b64\u5e93\u4f4d\u3002");
            return this.availableMaxXValue();
        }
        return this.getMappedValue(iAmInGroupList, 0, 10);
    }
}

