/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.List;

public class PolicyIdenticalNeighborhood
extends CubiclePolicy {
    public PolicyIdenticalNeighborhood(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myCubicle);
            }
        }
        return this.ignoreValue();
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        List<Cubicle> cubes = myCubicle.getMyAlley().getMyCubicle();
        int identicall = 1;
        int identicalr = 1;
        for (int i = 0; i < cubes.size(); ++i) {
            if (cubes.get(i) != myCubicle) continue;
            if (i > 0 && (identicall = (int)this.identical(commonParams.getNewBracket(), cubes.get(i - 1).getMyBracket())) == -1 || i >= cubes.size() - 1) break;
            identicalr = this.identical(commonParams.getNewBracket(), cubes.get(i + 1).getMyBracket());
            break;
        }
        int identical = Math.min(identicall, identicalr);
        switch (identical) {
            case 0: {
                return this.getMappedValue(0.0);
            }
        }
        switch (this.mode) {
            case UNIFORM: {
                return this.getMappedValue(1.0);
            }
        }
        return this.getMappedValue(0.5);
    }

    private byte identical(Bracket myBracket, Bracket neighborBracket) {
        if (neighborBracket == null) {
            return 1;
        }
        if (neighborBracket.equals(myBracket)) {
            return 0;
        }
        return -1;
    }
}

