/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyLeaveEmpties
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyLeaveEmpties.class);

    public PolicyLeaveEmpties(String name) {
        super(name);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(myCubicle);
    }

    private double moveIn(Cubicle myCubicle) {
        District district = myCubicle.getMyAlley().getDistrict();
        int leaveEmpties = district.getLeaveMovableEmptyNumber(myCubicle.getFloor());
        Integer movableEmpties = district.getMovableEmptyNumber(myCubicle.getFloor());
        if (movableEmpties > leaveEmpties) {
            return this.getMappedValue(0.0);
        }
        return this.excludedXValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }
}

