/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyLeaveEmptyStocks
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyLeaveEmptyStocks.class);

    public PolicyLeaveEmptyStocks(String name) {
        super(name);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(myCubicle);
            }
        }
        return this.moveIn(myCubicle);
    }

    private double moveIn(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        if (myAlley.getMyCubicle().get(0) != myCubicle) {
            return this.getMappedValue(0.0);
        }
        for (Group group : myAlley.getGroups()) {
            if (group.getStacker() == null) continue;
            return group.getEmptyNumber(myCubicle.getSize()) > StorageConst.getEmptyNumber(group.getId()) ? this.getMappedValue(0.0) : this.excludedXValue();
        }
        LOG.error("\u4e0d\u53ef\u80fd\u8fd0\u884c\u7684\u4f4d\u7f6e\uff0c\u5e93\u4f4d " + myCubicle.getId() + " \u53d1\u751f\u4e86\u6570\u636e\u914d\u7f6e\u9519\u8bef\uff01");
        return this.excludedXValue();
    }

    private double moveOut(Cubicle myCubicle) {
        return this.ignoreValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }
}

