/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;

public class PolicyLeft2Alley
extends CubiclePolicy {
    public PolicyLeft2Alley(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myCubicle);
            }
        }
        return this.ignoreValue();
    }

    private int countEmptyCubeNumber(Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        boolean findMyCubicle = false;
        int emptyNumber = 0;
        for (Cubicle cube : myAlley.getMyCubicle()) {
            if (cube == myCubicle) {
                findMyCubicle = true;
            }
            if (cube.getMyBracket() != null || cube.getStatus() == StockStatus.forbiden) break;
            ++emptyNumber;
        }
        if (findMyCubicle) {
            return emptyNumber;
        }
        if (myAlley.getMyCubicle().get(myAlley.getMyCubicle().size() - 1).getEntryType() == CubicleEntry.no) {
            return 0;
        }
        emptyNumber = 0;
        for (int i = myAlley.getMyCubicle().size() - 1; i >= 0; --i) {
            Cubicle cube;
            cube = myAlley.getMyCubicle().get(i);
            if (cube == myCubicle) {
                findMyCubicle = true;
            }
            if (cube.getMyBracket() != null || cube.getStatus() == StockStatus.forbiden) break;
            ++emptyNumber;
        }
        if (findMyCubicle) {
            return emptyNumber;
        }
        return 0;
    }

    private double moveIn(CommonParams params, Cubicle myCubicle) {
        if (myCubicle.getMyBracket() != null) {
            return this.excludedXValue();
        }
        if (params.getLeftCargoNumber() == -1) {
            return this.ignoreValue();
        }
        if (params.getLeftCargoNumber() > StorageConst.MaxEmptyCubeNumber) {
            return this.ignoreValue();
        }
        int emptyNumber = this.countEmptyCubeNumber(myCubicle);
        if (emptyNumber == params.getLeftCargoNumber()) {
            return this.getMappedValue(0.0);
        }
        if (this.mode == AlgorithomMode.UNIFORM) {
            return this.excludedXValue();
        }
        return this.availableMaxXValue();
    }
}

