/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;

public class PolicyLeftCargo
extends AlleyPolicy {
    public PolicyLeftCargo(String name) {
        super(name);
        this.setMode(AlgorithomMode.IGNORE);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private int getAllowedFloorNumber(CommonParams params) {
        int allowedFloorNumber = params.getFixedFloor().size();
        if (allowedFloorNumber == 0) {
            allowedFloorNumber = Integer.MAX_VALUE;
        } else if (allowedFloorNumber < StorageConst.DefaultMinFloorNumber) {
            allowedFloorNumber = StorageConst.DefaultMinFloorNumber;
        }
        int limitedFloorNumber = params.getFloorNumber();
        if (limitedFloorNumber == 0) {
            limitedFloorNumber = Integer.MAX_VALUE;
        } else if (limitedFloorNumber < StorageConst.DefaultMinFloorNumber) {
            limitedFloorNumber = StorageConst.DefaultMinFloorNumber;
        }
        int ret = Math.min(allowedFloorNumber, limitedFloorNumber);
        if (ret == Integer.MAX_VALUE) {
            return StorageConst.DefaultMinFloorNumber;
        }
        return Math.min(allowedFloorNumber, limitedFloorNumber);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        int emptyCubeNumber;
        if (params.getLeftCargoNumber() == -1) {
            return this.ignoreValue();
        }
        if (params.getLeftCargoNumber() <= 0) {
            return this.getDefaultExcludedValue();
        }
        int allowedFloorNumber = this.getAllowedFloorNumber(params);
        int inc = params.getLeftCargoNumber() % allowedFloorNumber == 0 ? 0 : 1;
        allowedFloorNumber = params.getLeftCargoNumber() / allowedFloorNumber + inc;
        if (allowedFloorNumber > (emptyCubeNumber = myAlley.allEmptyCubicles())) {
            return this.getMappedValue(0.5);
        }
        int diffFloorNumber = emptyCubeNumber - allowedFloorNumber;
        if (diffFloorNumber > 1) {
            return this.getMappedValue(0.5);
        }
        if (diffFloorNumber == 1) {
            return this.getMappedValue(0.25);
        }
        return this.getMappedValue(0.0);
    }
}

