/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMissoinControl
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyMissoinControl.class);

    public PolicyMissoinControl(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myCubicle);
            }
        }
        return this.ignoreValue();
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        int missionNumber = commonParams.getMissionNumber(myCubicle.getFloor());
        if (missionNumber == -1) {
            return this.ignoreValue();
        }
        if (commonParams.getMaxMission() == -1 || commonParams.getMaxMission() < 1) {
            LOG.warn("\u6700\u5927\u4efb\u52a1\u6570 " + commonParams.getMaxMission() + " \u65e0\u6548\uff01");
            return this.ignoreValue();
        }
        return this.getMappedValue(missionNumber, 0, commonParams.getMaxMission());
    }
}

