/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.Cargo;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMixCargo
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyMixCargo.class);

    public PolicyMixCargo(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myCubicle);
            }
        }
        return this.moveIn(commonParams, myCubicle);
    }

    private boolean isABA(CommonParams commonParams, Cubicle myCubicle) {
        int i;
        List<Cubicle> cubes = myCubicle.getMyAlley().getMyCubicle();
        boolean findMe = false;
        for (i = 0; i < cubes.size() - 2; ++i) {
            if (myCubicle == cubes.get(i)) {
                findMe = true;
            }
            if (cubes.get(i + 1).getMyBracket() == null) continue;
            if (cubes.get(i + 1).getMyBracket() == null || cubes.get(i + 2).getMyBracket() == null || !findMe || cubes.get(i + 1).getMyBracket().equals(cubes.get(i + 2).getMyBracket()) || !commonParams.equals(cubes.get(i + 2).getMyBracket())) break;
            return true;
        }
        if (cubes.get(cubes.size() - 1).getEntryType() == CubicleEntry.no) {
            return false;
        }
        findMe = false;
        for (i = cubes.size() - 1; i > 1; --i) {
            if (myCubicle == cubes.get(i)) {
                findMe = true;
            }
            if (cubes.get(i - 1).getMyBracket() == null) continue;
            if (cubes.get(i - 1).getMyBracket() == null || cubes.get(i - 2).getMyBracket() == null || !findMe || cubes.get(i - 1).getMyBracket().equals(cubes.get(i - 2).getMyBracket()) || !commonParams.equals(cubes.get(i - 2).getMyBracket())) break;
            return true;
        }
        return false;
    }

    private int neighborBracketCompatibleNumber(CommonParams commonParams, Cubicle myCubicle) {
        List<Cubicle> cubes = myCubicle.getMyAlley().getMyCubicle();
        ArrayList<Cargo> mixCargos = new ArrayList<Cargo>();
        mixCargos.add(commonParams);
        for (Cubicle cube : cubes) {
            if (cube.getMyBracket() == null) continue;
            if (!commonParams.compatibleWith(cube.getMyBracket())) {
                return -1;
            }
            if (mixCargos.stream().anyMatch(cargo -> cargo.equals(cube.getMyBracket()))) continue;
            mixCargos.add(cube.getMyBracket());
            if (mixCargos.size() <= StorageConst.MaxMixNumber) continue;
            return -1;
        }
        return mixCargos.size();
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        if (myCubicle.getMyBracket() != null) {
            return this.excludedXValue();
        }
        if (this.isABA(commonParams, myCubicle)) {
            if (this.getMode() == AlgorithomMode.UNIFORM) {
                return this.excludedXValue();
            }
            return this.availableMaxXValue();
        }
        int mixNum = this.neighborBracketCompatibleNumber(commonParams, myCubicle);
        if (mixNum == -1) {
            if (this.getMode() == AlgorithomMode.UNIFORM) {
                return this.excludedXValue();
            }
            return this.availableMaxXValue();
        }
        if (StorageConst.MaxMixNumber == 1) {
            return this.getMappedValue(0.0);
        }
        return this.getMappedValue(mixNum, 1, StorageConst.MaxMixNumber);
    }

    private double moveOut(CommonParams commonParams, Cubicle myCubicle) {
        return this.ignoreValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }
}

