/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyPosition
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyPosition.class);

    public PolicyPosition(String name) {
        super(name);
    }

    public static int getZWeight(District district) {
        if (district.isShuttle()) {
            return 6;
        }
        return 4;
    }

    public static int getMaxDistance(District district) {
        int zWeight = PolicyPosition.getZWeight(district);
        return 8 + zWeight;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        if (commonParams.getStartX() != Integer.MIN_VALUE && commonParams.getStartY() != Integer.MIN_VALUE) {
            return this.move(commonParams, myCubicle);
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myCubicle);
            }
        }
        return this.moveIn(commonParams, myCubicle);
    }

    private double move(CommonParams commonParams, Cubicle myCubicle) {
        Alley myAlley = myCubicle.getMyAlley();
        int maxDistance = myAlley.getDistrict().getDepth() + myAlley.getDistrict().getLength();
        Cubicle leftCube = myAlley.getMyCubicle().get(0);
        int leftDistance = Math.abs(leftCube.getX() - commonParams.getStartX()) + Math.abs(leftCube.getY() - commonParams.getStartY());
        Cubicle rightCube = myAlley.getMyCubicle().get(myAlley.getMyCubicle().size() - 1);
        int rightDistance = Integer.MAX_VALUE;
        if (rightCube.getEntryType() != CubicleEntry.no) {
            rightDistance = Math.abs(rightCube.getX() - commonParams.getStartX()) + Math.abs(rightCube.getY() - commonParams.getStartY());
        }
        int finalDistance = Math.min(leftDistance, rightDistance);
        return this.getMappedValue(finalDistance, 1, maxDistance);
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        int myDistance = -1;
        if (myCubicle.getMyAlley().getDistrict().isStacker()) {
            myDistance = this.getStackerDistance(myCubicle);
        } else if (myCubicle.getMyAlley().getDistrict().isShuttle()) {
            myDistance = this.getShuttleDistance(myCubicle);
        } else {
            LOG.error("\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u5df2\u77e5\u7684\u5e93\u533a\u5206\u7c7b\uff01");
            return this.ignoreValue();
        }
        int maxDistance = PolicyPosition.getMaxDistance(myCubicle.getMyAlley().getDistrict());
        if (myDistance < 0) {
            myDistance = maxDistance;
        }
        myDistance = Math.min(myDistance, maxDistance);
        return this.getMappedValue(myDistance, 1, maxDistance);
    }

    private double moveOut(CommonParams commonParams, Cubicle myCubicle) {
        return this.ignoreValue();
    }

    private int getStackerDistance(Cubicle myCubicle) {
        return myCubicle.getMyAlley().getMyCubicle().get(0).getDistanceSteps();
    }

    private int getShuttleDistance(Cubicle myCubicle) {
        int myDistance = myCubicle.getMyAlley().getMyCubicle().get(0).getDistanceSteps();
        Cubicle farCubicle = myCubicle.getMyAlley().getMyCubicle().get(myCubicle.getMyAlley().getMyCubicle().size() - 1);
        if (farCubicle.getEntryType() != CubicleEntry.no) {
            myDistance = Math.min(myDistance, farCubicle.getDistanceSteps());
        }
        return myDistance;
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }
}

