/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.Categories;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyShelfBearing
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyShelfBearing.class);

    public PolicyShelfBearing(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myCubicle);
            }
        }
        return this.moveIn(commonParams, myCubicle);
    }

    private double moveIn(CommonParams commonParams, Cubicle myCubicle) {
        int currentCargoWeight = commonParams.getMyShelfWeight(myCubicle.getShelfId());
        if (currentCargoWeight == -1) {
            currentCargoWeight = 0;
            List<Cubicle> cubicles = Categories.getShelfsMap(false).get(myCubicle.getMyAlley().getDistrict().getId() + "-" + myCubicle.getShelfId());
            if (cubicles == null) {
                LOG.error(myCubicle + "\u6ca1\u6709\u672c\u8d27\u67b6\u4efb\u4f55\u8bb0\u5f55\uff0c\u5254\u9664\u672c\u5e93\u4f4d\u3002");
                return this.excludedXValue();
            }
            for (Cubicle cubicle : cubicles) {
                Bracket bracket = cubicle.getMyBracket();
                if (bracket == null) continue;
                currentCargoWeight += Integer.valueOf(bracket.get("\u8d27\u7269\u8d28\u91cf")).intValue();
            }
        }
        if (currentCargoWeight + Integer.valueOf(commonParams.getNewBracket().get("\u8d27\u7269\u8d28\u91cf")) >= StorageConst.getBearing(myCubicle.getShelfId())) {
            return this.excludedXValue();
        }
        return this.getMappedValue(currentCargoWeight, 0, StorageConst.getBearing(myCubicle.getShelfId()));
    }

    private double moveOut(CommonParams commonParams, Cubicle myCubicle) {
        return this.ignoreValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }
}

