/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyShuttleFixFloors
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyShuttleFixFloors.class);

    public PolicyShuttleFixFloors(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        if (params.getFixedFloor().isEmpty()) {
            return this.ignoreValue();
        }
        int inFloors = params.isInFixedFloor(myAlley.getMyCubicle().get(0).getFloor());
        if (inFloors >= 0) {
            return this.getMappedValue(inFloors, 0, params.getFixedFloor().size());
        }
        switch (this.mode) {
            case UNIFORM: {
                return this.excludedXValue();
            }
        }
        return this.availableMaxXValue();
    }
}

