/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyShuttleLimitedFloorNumber
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyShuttleLimitedFloorNumber.class);

    public PolicyShuttleLimitedFloorNumber(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        if (params.getFloorNumber() == -1) {
            return this.ignoreValue();
        }
        if (params.getCargofloors().size() < params.getFloorNumber()) {
            if (params.getCargofloors().containsKey(myAlley.getMyCubicle().get(0).getFloor())) {
                return this.getMappedValue(0.5);
            }
            return this.getMappedValue(0.0);
        }
        if (params.getCargofloors().containsKey(myAlley.getMyCubicle().get(0).getFloor())) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int num : params.getCargofloors().values()) {
                if (num < min) {
                    min = num;
                }
                if (num <= max) continue;
                max = num;
            }
            if (min == max) {
                return this.ignoreValue();
            }
            return this.getMappedValue(params.getCargofloors().get(myAlley.getMyCubicle().get(0).getFloor()), min, max);
        }
        if (this.mode == AlgorithomMode.UNIFORM) {
            return this.excludedXValue();
        }
        return this.availableMaxXValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }
}

