/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.Car;
import com.wisdom.storalgorithm.element.base.CarStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyShuttleSelection
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyShuttleSelection.class);

    public PolicyShuttleSelection(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams params, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        return this.move(params, myAlley);
    }

    private double move(CommonParams params, Alley myAlley) {
        List<Car> shuttles = myAlley.getDistrict().getCars();
        long shuttleCount = shuttles.stream().filter(shuttle -> shuttle.getStatus() != CarStatus.fault).filter(shuttle -> shuttle.position()[2] == myAlley.getMyCubicle().get(0).getFloor()).count();
        if (shuttleCount == 0L && this.mode == AlgorithomMode.UNIFORM) {
            return this.excludedXValue();
        }
        return this.getMappedValue(shuttleCount, 0.0, (double)shuttles.size());
    }
}

