/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;

public class PolicyStackerFixFloors
extends AlleyPolicy {
    public PolicyStackerFixFloors(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        if (params.getFixedFloor().isEmpty()) {
            return this.ignoreValue();
        }
        if (params.getFixedFloor().contains(myAlley.getMyCubicle().get(0).getFloor())) {
            return this.getMappedValue(0.0);
        }
        switch (this.mode) {
            case UNIFORM: {
                return this.excludedXValue();
            }
        }
        return this.availableMaxXValue();
    }
}

