/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.utils.CommonParams;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyStackerGroups
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyStackerGroups.class);

    public PolicyStackerGroups(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(commonParams, myAlley);
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams commonParams, Alley myAlley) {
        Set<Group> myGroups = myAlley.getGroups();
        boolean iAmInStackerList = myGroups.stream().filter(group -> group.getStacker() != null).anyMatch(group -> commonParams.getStackers().stream().anyMatch(stacker -> group.getStacker() == stacker));
        if (iAmInStackerList) {
            return this.ignoreValue();
        }
        if (this.getMode() == AlgorithomMode.UNIFORM) {
            return this.excludedXValue();
        }
        return this.getMappedValue(0.5);
    }

    private double moveOut(CommonParams commonParams, Alley myAlley) {
        return this.ignoreValue();
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }
}

