/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;

public class PolicyStackerLimitedNumber
extends AlleyPolicy {
    public PolicyStackerLimitedNumber(String name) {
        super(name);
        this.setMode(AlgorithomMode.UNIFORM);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myAlley);
            }
        }
        return this.ignoreValue();
    }

    private double moveIn(CommonParams commonParams, Alley myAlley) {
        if (commonParams.getLimitedStackerNumber() == -1) {
            return this.ignoreValue();
        }
        if (commonParams.getStackersWithMyCargo().contains(myAlley.getStacker())) {
            return this.getMappedValue(0.0);
        }
        if (commonParams.getStackersWithMyCargo().size() < commonParams.getLimitedStackerNumber()) {
            return this.getMappedValue(0.0);
        }
        if (this.mode == AlgorithomMode.UNIFORM) {
            return this.excludedXValue();
        }
        return this.availableMaxXValue();
    }
}

