/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.Car;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyStackerMissions
extends AlleyPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyStackerMissions.class);

    public PolicyStackerMissions(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.STACKER;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.ignoreValue();
            }
        }
        return this.moveIn(commonParams, myAlley);
    }

    private double moveIn(CommonParams params, Alley myAlley) {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < params.getMyDistrict().getCars().size(); ++i) {
            Car stacker = params.getMyDistrict().getCars().get(i);
            if (max < stacker.getMissionNumber()) {
                max = stacker.getMissionNumber();
            }
            if (min <= stacker.getMissionNumber()) continue;
            min = stacker.getMissionNumber();
        }
        if (max == 0 || min == max) {
            return this.ignoreValue();
        }
        Stacker myStacker = myAlley.getStacker();
        if (myStacker == null) {
            LOG.error(myAlley + " \u65e0\u6307\u5b9a\u7684\u5806\u579b\u673a\uff01");
            return this.excludedXValue();
        }
        return this.getMappedValue(myStacker.getMissionNumber(), min, max);
    }
}

