/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.AlleyPolicy;
import com.wisdom.storalgorithm.element.base.StockSize;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.utils.CommonParams;

public class PolicyStockSize
extends AlleyPolicy {
    public PolicyStockSize(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.BOTH;
    }

    @Override
    public double x(CommonParams commonParams, Alley myAlley) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveIn: {
                return this.moveIn(commonParams, myAlley);
            }
        }
        return this.ignoreValue();
    }

    private double moveIn(CommonParams commonParams, Alley myAlley) {
        if (commonParams.getStockSize() == StockSize.Undefined) {
            return this.ignoreValue();
        }
        StockSize cubeSize = myAlley.getMyCubicle().get(0).getSize();
        if (commonParams.getStockSize() == StockSize.Big) {
            if (cubeSize == StockSize.Big) {
                return this.ignoreValue();
            }
            return this.excludedXValue();
        }
        if (cubeSize == StockSize.Normal) {
            return this.ignoreValue();
        }
        if (this.mode == AlgorithomMode.UNIFORM || !commonParams.isMixSize()) {
            return this.excludedXValue();
        }
        return this.availableMaxXValue();
    }
}

