/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.policy;

import com.wisdom.storalgorithm.element.base.AlgorithomMode;
import com.wisdom.storalgorithm.element.base.CubicleEntry;
import com.wisdom.storalgorithm.element.base.CubiclePolicy;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuttleInternalFirst
extends CubiclePolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ShuttleInternalFirst.class);

    public ShuttleInternalFirst(String name) {
        super(name);
    }

    @Override
    public StockType supportedCarType() {
        return StockType.SHUTTLE;
    }

    @Override
    public double x(CommonParams commonParams, Cubicle myCubicle) {
        if (this.mode == AlgorithomMode.IGNORE) {
            return this.ignoreValue();
        }
        switch (commonParams.getBehavior()) {
            case moveOut: {
                return this.moveOut(myCubicle);
            }
        }
        return this.moveIn(myCubicle);
    }

    private boolean doubleEntries(Cubicle myCubicle) {
        int alleyLength = myCubicle.getMyAlley().getMyCubicle().size();
        return alleyLength >= 2 && myCubicle.getMyAlley().getMyCubicle().get(alleyLength - 1).getEntryType() != CubicleEntry.no;
    }

    private double moveIn(Cubicle myCubicle) {
        int index;
        int indexl = Integer.MAX_VALUE;
        boolean isDoubleEntries = this.doubleEntries(myCubicle);
        int alleyLength = myCubicle.getMyAlley().getMyCubicle().size();
        for (int i = 0; i < alleyLength && myCubicle.getMyAlley().getMyCubicle().get(i).getMyBracket() == null; ++i) {
            if (myCubicle.getMyAlley().getMyCubicle().get(i) != myCubicle) continue;
            indexl = i;
            break;
        }
        int indexr = Integer.MAX_VALUE;
        if (isDoubleEntries) {
            for (int i = alleyLength - 1; i >= 0 && myCubicle.getMyAlley().getMyCubicle().get(i).getMyBracket() == null; --i) {
                if (myCubicle.getMyAlley().getMyCubicle().get(i) != myCubicle) continue;
                indexr = alleyLength - 1 - i;
                break;
            }
        }
        if ((index = Math.min(indexl, indexr)) == Integer.MAX_VALUE) {
            LOG.warn("\u6570\u636e\u914d\u7f6e\u9519\u8bef\u6216\u8005\u7a7a\u5e93\u4f4d\u88ab\u5835\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u4e3a\u5e93\u4f4d" + myCubicle.getId() + " \u914d\u7f6e\u7684\u6570\u636e\uff01");
            return this.excludedXValue();
        }
        return this.getMappedValue(alleyLength - 1 - index, 0, alleyLength);
    }

    private double moveOut(Cubicle myCubicle) {
        int index;
        int alleyLength = myCubicle.getMyAlley().getMyCubicle().size();
        for (index = 0; index < alleyLength && myCubicle.getMyAlley().getMyCubicle().get(index) != myCubicle; ++index) {
        }
        if (index >= myCubicle.getMyAlley().getMyCubicle().size()) {
            LOG.error("\u6570\u636e\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u4e3a\u5e93\u4f4d" + myCubicle.getId() + " \u914d\u7f6e\u7684\u6570\u636e\uff01");
            return this.excludedXValue();
        }
        if (myCubicle.getMyAlley().getMyCubicle().get(alleyLength - 1).getEntryType() == CubicleEntry.no || alleyLength < 2) {
            return this.getMappedValue(index, 0, alleyLength);
        }
        return this.getMappedValue((double)Math.min(index, alleyLength - 1 - index), 0.0, Math.round((double)alleyLength / 2.0 - 0.2));
    }
}

