/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.utils;

import com.wisdom.storalgorithm.MainStorageAlgorithm;
import com.wisdom.storalgorithm.element.base.Behavior;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.element.store.Warehouse;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.item.CubicleSaver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Categories {
    private static final Logger LOG = LoggerFactory.getLogger(Categories.class);
    private static final Map<String, List<Cubicle>> SHELFS = new HashMap<String, List<Cubicle>>();
    private static final List<List<Cubicle>> FLOORS = new ArrayList<List<Cubicle>>();

    private Categories() {
    }

    public static Map<String, List<Cubicle>> getShelfsMap(boolean fresh) {
        if (!fresh && !SHELFS.isEmpty()) {
            return SHELFS;
        }
        SHELFS.clear();
        List<District> districts = Warehouse.INST.getAllDistricts();
        districts.stream().forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cubicle -> {
            String shelfId = district.getId() + "-" + cubicle.getShelfId();
            List<Cubicle> cubicles = SHELFS.get(shelfId);
            if (cubicles == null) {
                cubicles = new ArrayList<Cubicle>();
                SHELFS.put(shelfId, cubicles);
            }
            cubicles.add((Cubicle)cubicle);
        })));
        return SHELFS;
    }

    public static List<List<Cubicle>> getFloorsList(boolean fresh) {
        if (!fresh) {
            return FLOORS;
        }
        FLOORS.clear();
        IntStream.range(0, 30).forEach(floor -> FLOORS.add(new ArrayList()));
        List<District> districts = Warehouse.INST.getAllDistricts();
        districts.stream().forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cubicle -> {
            int floor = cubicle.getFloor();
            List<Cubicle> cubicles = FLOORS.get(floor);
            cubicles.add((Cubicle)cubicle);
        })));
        return FLOORS;
    }

    public static String zeroOnePack(int V, int N, int[] weight, double[] value) {
        double[][] dp = new double[N + 1][V + 1];
        for (int i = 1; i <= N; ++i) {
            for (int j = 1; j <= V; ++j) {
                dp[i][j] = weight[i - 1] > j ? dp[i - 1][j] : Math.max(dp[i - 1][j], dp[i - 1][j - weight[i - 1]] + value[i - 1]);
            }
        }
        double maxValue = dp[N][V];
        int j = V;
        String numStr = "";
        for (int i = N; i > 0; --i) {
            if (dp[i][j] > dp[i - 1][j]) {
                numStr = i + " " + numStr;
                j -= weight[i - 1];
            }
            if (j == 0) break;
        }
        return numStr;
    }

    private static boolean compareList(List<?> a, List<?> b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }

    public static List<Cubicle> moveOutCubes(List<Cubicle> cubes, CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        Object[] savers = cubes.stream().map(cube -> new CubicleSaver((Cubicle)cube)).collect(Collectors.toList()).toArray(new CubicleSaver[0]);
        Arrays.sort(savers);
        int V = Integer.valueOf(expectedParam.get("\u8d27\u54c1\u4ef6\u6570"));
        int N = cubes.size();
        double[][] dp = new double[N + 1][V + 1];
        List[] comps = new List[N + 1];
        for (int i = 1; i <= N; ++i) {
            block1: for (int j = 1; j <= V; ++j) {
                int packNum = ((CubicleSaver)savers[i - 1]).getPackNumber();
                if (packNum > j) {
                    dp[i][j] = dp[i - 1][j];
                    continue;
                }
                int j2 = j - packNum;
                ArrayList<Cubicle> comp = new ArrayList<Cubicle>();
                for (int i2 = i - 1; i2 > 0; --i2) {
                    if (dp[i2][j2] > dp[i2 - 1][j2]) {
                        ((CubicleSaver)savers[i2 - 1]).clear();
                        comp.add(((CubicleSaver)savers[i - 1]).getCube());
                        j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j2 == 0) break;
                }
                boolean isSame = Categories.compareList(comp, comps[i]);
                comps[i] = comp;
                dp[i][j] = Math.max(dp[i - 1][j], dp[i - 1][j - packNum] + ((CubicleSaver)savers[i - 1]).getValue(expectedParam, isSame));
                j2 = j - packNum;
                for (int i2 = i - 1; i2 > 0; --i2) {
                    if (dp[i2][j2] > dp[i2 - 1][j2]) {
                        ((CubicleSaver)savers[i2 - 1]).restore();
                        j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j2 == 0) continue block1;
                }
            }
        }
        Arrays.asList(savers).stream().forEach(saver -> saver.restore());
        double maxValue = dp[N][V];
        int j = V;
        for (int i = N; i > 0; --i) {
            if (dp[i][j] > dp[i - 1][j]) {
                ret.add(0, ((CubicleSaver)savers[i - 1]).getCube());
                j -= ((CubicleSaver)savers[i - 1]).getPackNumber();
            }
            if (j == 0) break;
        }
        return ret;
    }

    public static List<Cubicle> moveOutCubes2(List<Cubicle> cubes, CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        int expandSize = 32;
        Object[] savers = cubes.stream().map(cube -> new CubicleSaver((Cubicle)cube)).collect(Collectors.toList()).toArray(new CubicleSaver[0]);
        Arrays.sort(savers);
        int neededPackCount = Integer.valueOf(expectedParam.get("\u8d27\u54c1\u4ef6\u6570"));
        int V = cubes.stream().mapToInt(cube -> Integer.valueOf(cube.getMyBracket().get("\u8d27\u54c1\u4ef6\u6570"))).sum();
        int N = cubes.size();
        double[][] dp = new double[N + 1][neededPackCount + 1];
        for (int j = 1; j <= V; ++j) {
            if (j >= dp[0].length) {
                double[] tmp = new double[dp[0].length + 32];
                System.arraycopy(dp[0], 0, tmp, 0, dp[0].length);
                dp[0] = tmp;
            }
            for (int i = 1; i <= N; ++i) {
                int tmpTotalPacks;
                int packNum;
                if (j >= dp[i].length) {
                    double[] tmp = new double[dp[i].length + 32];
                    System.arraycopy(dp[i], 0, tmp, 0, dp[i].length);
                    dp[i] = tmp;
                }
                if ((packNum = ((CubicleSaver)savers[i - 1]).getPackNumber()) > j) {
                    dp[i][j] = dp[i - 1][j];
                } else {
                    int i2;
                    int j2 = j - packNum;
                    for (i2 = i - 1; i2 > 0; --i2) {
                        if (dp[i2][j2] > dp[i2 - 1][j2]) {
                            ((CubicleSaver)savers[i2 - 1]).clear();
                            j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                        }
                        if (j2 == 0) break;
                    }
                    dp[i][j] = Math.max(dp[i - 1][j], dp[i - 1][j - packNum] + ((CubicleSaver)savers[i - 1]).getValue(expectedParam, false));
                    j2 = j - packNum;
                    for (i2 = i - 1; i2 > 0; --i2) {
                        if (dp[i2][j2] > dp[i2 - 1][j2]) {
                            ((CubicleSaver)savers[i2 - 1]).restore();
                            j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                        }
                        if (j2 == 0) break;
                    }
                }
                if (i != N || j < neededPackCount) continue;
                ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
                int j3 = j;
                for (int i2 = N; i2 > 0; --i2) {
                    if (dp[i2][j3] > dp[i2 - 1][j3]) {
                        ret.add(0, ((CubicleSaver)savers[i2 - 1]).getCube());
                        j3 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j3 == 0) break;
                }
                if ((tmpTotalPacks = ret.stream().mapToInt(cube -> Integer.valueOf(cube.getMyBracket().get("\u8d27\u54c1\u4ef6\u6570"))).sum()) < neededPackCount) continue;
                Arrays.asList(savers).stream().forEach(saver -> saver.restore());
                return ret;
            }
        }
        Arrays.asList(savers).stream().forEach(saver -> saver.restore());
        double maxValue = dp[N][V];
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        int j = V;
        for (int i = N; i > 0; --i) {
            if (dp[i][j] > dp[i - 1][j]) {
                ret.add(0, ((CubicleSaver)savers[i - 1]).getCube());
                j -= ((CubicleSaver)savers[i - 1]).getPackNumber();
            }
            if (j == 0) break;
        }
        return ret;
    }

    public static List<Cubicle> moveOutCubes3(List<Cubicle> cubes, CommonParams expectedParam) {
        List<Cubicle> outputCubes;
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        for (int neededPackCount = Integer.valueOf(expectedParam.get("\u8d27\u54c1\u4ef6\u6570")).intValue(); neededPackCount > 0; neededPackCount -= Integer.valueOf(outputCubes.get(0).getMyBracket().get("\u8d27\u54c1\u4ef6\u6570")).intValue()) {
            outputCubes = MainStorageAlgorithm.getMultipleMoveOutCube(expectedParam, 1);
            if (outputCubes.size() < 1) {
                LOG.error("\u627e\u4e0d\u5230\u5408\u9002\u7684\u51fa\u5e93\u4f4d\uff01");
                return ret;
            }
            ret.addAll(outputCubes);
        }
        return ret;
    }

    public static List<Cubicle> moveOutCubesFilled(List<Cubicle> cubes, CommonParams expectedParam) {
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        Object[] savers = cubes.stream().map(cube -> new CubicleSaver((Cubicle)cube)).collect(Collectors.toList()).toArray(new CubicleSaver[0]);
        Arrays.sort(savers);
        int V = Integer.valueOf(expectedParam.get("\u8d27\u54c1\u4ef6\u6570"));
        int N = cubes.size();
        double[][] dp = new double[N + 1][V + 1];
        for (int j = 1; j <= V; ++j) {
            dp[0][j] = -1.0;
        }
        for (int i = 1; i <= N; ++i) {
            block2: for (int j = 1; j <= V; ++j) {
                int i2;
                int packNum = ((CubicleSaver)savers[i - 1]).getPackNumber();
                if (packNum > j || dp[i - 1][j - packNum] < 0.0) {
                    dp[i][j] = dp[i - 1][j];
                    continue;
                }
                int j2 = j - packNum;
                for (i2 = i - 1; i2 > 0; --i2) {
                    if (dp[i2][j2] > dp[i2 - 1][j2]) {
                        ((CubicleSaver)savers[i2 - 1]).clear();
                        j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j2 == 0) break;
                }
                dp[i][j] = Math.max(dp[i - 1][j], dp[i - 1][j - packNum] + ((CubicleSaver)savers[i - 1]).getValue(expectedParam, false));
                j2 = j - packNum;
                for (i2 = i - 1; i2 > 0; --i2) {
                    if (dp[i2][j2] > dp[i2 - 1][j2]) {
                        ((CubicleSaver)savers[i2 - 1]).restore();
                        j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j2 == 0) continue block2;
                }
            }
        }
        Arrays.asList(savers).stream().forEach(saver -> saver.restore());
        double maxValue = dp[N][V];
        int j = V;
        for (int i = N; i > 0; --i) {
            if (dp[i][j] > dp[i - 1][j]) {
                ret.add(0, ((CubicleSaver)savers[i - 1]).getCube());
                j -= ((CubicleSaver)savers[i - 1]).getPackNumber();
            }
            if (j == 0) break;
        }
        return ret;
    }

    public static List<Cubicle> moveOutCubesFilled2(List<Cubicle> cubes, CommonParams expectedParam) {
        int j;
        if (expectedParam.getBehavior() != Behavior.moveOut) {
            throw new StatusException("\u51fa\u5e93\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8f93\u5165\u5165\u5e93\u53c2\u6570\uff01");
        }
        int expandSize = 32;
        double[] tmpInitCopy = new double[32];
        for (int i = 0; i < 32; ++i) {
            tmpInitCopy[i] = -1.0;
        }
        Object[] savers = cubes.stream().map(cube -> new CubicleSaver((Cubicle)cube)).collect(Collectors.toList()).toArray(new CubicleSaver[0]);
        Arrays.sort(savers);
        int neededPackCount = Integer.valueOf(expectedParam.get("\u8d27\u54c1\u4ef6\u6570"));
        int V = cubes.stream().mapToInt(cube -> Integer.valueOf(cube.getMyBracket().get("\u8d27\u54c1\u4ef6\u6570"))).sum();
        int N = cubes.size();
        double[][] dp = new double[N + 1][neededPackCount + 1];
        for (j = 1; j <= neededPackCount; ++j) {
            dp[0][j] = -1.0;
        }
        for (j = 1; j <= V; ++j) {
            if (j >= dp[0].length) {
                double[] tmp = new double[dp[0].length + 32];
                System.arraycopy(dp[0], 0, tmp, 0, dp[0].length);
                System.arraycopy(tmpInitCopy, 0, tmp, dp[0].length, tmpInitCopy.length);
                dp[0] = tmp;
            }
            for (int i = 1; i <= N; ++i) {
                int tmpTotalPacks;
                int packNum;
                if (j >= dp[i].length) {
                    double[] tmp = new double[dp[i].length + 32];
                    System.arraycopy(dp[i], 0, tmp, 0, dp[i].length);
                    System.arraycopy(tmpInitCopy, 0, tmp, dp[i].length, tmpInitCopy.length);
                    dp[i] = tmp;
                }
                if ((packNum = ((CubicleSaver)savers[i - 1]).getPackNumber()) > j || dp[i - 1][j - packNum] < 0.0) {
                    dp[i][j] = dp[i - 1][j];
                } else {
                    int i2;
                    int j2 = j - packNum;
                    for (i2 = i - 1; i2 > 0; --i2) {
                        if (dp[i2][j2] > dp[i2 - 1][j2]) {
                            ((CubicleSaver)savers[i2 - 1]).clear();
                            j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                        }
                        if (j2 == 0) break;
                    }
                    dp[i][j] = Math.max(dp[i - 1][j], dp[i - 1][j - packNum] + ((CubicleSaver)savers[i - 1]).getValue(expectedParam, false));
                    j2 = j - packNum;
                    for (i2 = i - 1; i2 > 0; --i2) {
                        if (dp[i2][j2] > dp[i2 - 1][j2]) {
                            ((CubicleSaver)savers[i2 - 1]).restore();
                            j2 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                        }
                        if (j2 == 0) break;
                    }
                }
                if (i != N || j < neededPackCount) continue;
                ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
                int j3 = j;
                for (int i2 = N; i2 > 0; --i2) {
                    if (dp[i2][j3] > dp[i2 - 1][j3]) {
                        ret.add(0, ((CubicleSaver)savers[i2 - 1]).getCube());
                        j3 -= ((CubicleSaver)savers[i2 - 1]).getPackNumber();
                    }
                    if (j3 == 0) break;
                }
                if ((tmpTotalPacks = ret.stream().mapToInt(cube -> Integer.valueOf(cube.getMyBracket().get("\u8d27\u54c1\u4ef6\u6570"))).sum()) < neededPackCount) continue;
                Arrays.asList(savers).stream().forEach(saver -> saver.restore());
                return ret;
            }
        }
        Arrays.asList(savers).stream().forEach(saver -> saver.restore());
        double maxValue = dp[N][V];
        ArrayList<Cubicle> ret = new ArrayList<Cubicle>();
        int j2 = V;
        for (int i = N; i > 0; --i) {
            if (dp[i][j2] > dp[i - 1][j2]) {
                ret.add(0, ((CubicleSaver)savers[i - 1]).getCube());
                j2 -= ((CubicleSaver)savers[i - 1]).getPackNumber();
            }
            if (j2 == 0) break;
        }
        return ret;
    }
}

