/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.utils;

import com.wisdom.storalgorithm.element.base.Behavior;
import com.wisdom.storalgorithm.element.base.Car;
import com.wisdom.storalgorithm.element.base.Cargo;
import com.wisdom.storalgorithm.element.base.CargoLabel;
import com.wisdom.storalgorithm.element.base.StockSize;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.base.StockType;
import com.wisdom.storalgorithm.element.car.Stacker;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Alley;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.element.store.District;
import com.wisdom.storalgorithm.element.store.Group;
import com.wisdom.storalgorithm.element.store.Warehouse;
import com.wisdom.storalgorithm.exception.StatusException;
import com.wisdom.storalgorithm.policy.PolicyPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonParams
extends Cargo {
    private static final Logger LOG = LoggerFactory.getLogger(CommonParams.class);
    private District myDistrict;
    private Bracket newBracket = null;
    private Set<Cubicle> similarCubicles;
    private final Set<Cubicle> sameCubicles = new HashSet<Cubicle>();
    private final List<Integer> fixedFloor = new ArrayList<Integer>();
    private final Map<Integer, Integer> cargofloors = new HashMap<Integer, Integer>();
    private final Map<Group, Integer> groups = new HashMap<Group, Integer>();
    private final Map<String, Integer> shelfWeight = new HashMap<String, Integer>();
    private final Set<Car> stackersWithMyCargo = new HashSet<Car>();
    private List<Stacker> stackers = new ArrayList<Stacker>();
    private Map<Integer, Integer> missions = new HashMap<Integer, Integer>();
    private int maxMission = -1;
    private StockType carType = StockType.UNKNOWN;
    private Behavior behavior = Behavior.moveIn;
    private int maxPackNumber = 0;
    private int limitedStackerNumber = -1;
    private int leftCargoNumber = -1;
    private int startX = Integer.MIN_VALUE;
    private int startY = Integer.MIN_VALUE;
    private int floorNumber = -1;
    private boolean mixing = false;
    private StockSize stockSize = StockSize.Undefined;
    private boolean mixSize = false;

    public CommonParams(Behavior behavior) {
        if (behavior == null) {
            throw new StatusException("\u53c2\u6570\u884c\u4e3a\u521d\u59cb\u5316\u65f6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.behavior = behavior;
    }

    public int getLimitedStackerNumber() {
        return this.limitedStackerNumber;
    }

    public void setLimitedStackerNumber(int limitedStackerNumber) {
        this.limitedStackerNumber = limitedStackerNumber;
    }

    public Set<Car> getStackersWithMyCargo() {
        return this.stackersWithMyCargo;
    }

    public int getLeftCargoNumber() {
        return this.leftCargoNumber;
    }

    public void setLeftCargoNumber(int leftCargoNumber) {
        this.leftCargoNumber = leftCargoNumber;
    }

    public void initBeforeEverySearch() {
        if (this.myDistrict == null) {
            throw new StatusException("\u6ca1\u6709\u6307\u5b9a\u5e93\u533a\u4f5c\u4e3a\u521d\u59cb\u5316\u8d27\u7269\u53c2\u6570\uff01");
        }
        this.maxPackNumber = 0;
        this.myDistrict.countEmptyCubes();
        if (this.behavior == Behavior.moveIn) {
            this.markMatchCubicles();
            if (this.myDistrict.isStacker()) {
                this.calculateShelfWeight();
                this.calculateStackersWithMyCargos();
                this.markEmptyCubiclesNumber();
            } else if (this.myDistrict.isShuttle()) {
                this.populateCargoFloors();
                this.myDistrict.calculateMovableEmptyCubes();
            }
        } else {
            this.setSameCubicles(this.allMatchCubicles());
        }
    }

    public District getMyDistrict() {
        return this.myDistrict;
    }

    public void setMyDistrict(District myDistrict) {
        this.myDistrict = myDistrict;
        if (myDistrict.isShuttle()) {
            this.carType = StockType.SHUTTLE;
        } else if (myDistrict.isStacker()) {
            this.carType = StockType.STACKER;
        }
        LOG.info(this + " \u8bbe\u7f6e " + myDistrict);
    }

    public Set<Cubicle> getSimilarCubicles() {
        return this.similarCubicles;
    }

    public Set<Cubicle> getSameCubicles() {
        return this.sameCubicles;
    }

    private void setSimilarCubicles(Set<Cubicle> cubicles) {
        this.similarCubicles = cubicles;
        if (cubicles == null) {
            return;
        }
        OptionalInt value = cubicles.stream().filter(cube -> cube.getMyBracket() != null).mapToInt(cube -> cube.getMyBracket().getInt("\u8d27\u54c1\u4ef6\u6570")).max();
    }

    private void setSameCubicles(Set<Cubicle> cubicles) {
        if (cubicles == null) {
            return;
        }
        this.sameCubicles.clear();
        this.sameCubicles.addAll(cubicles);
        OptionalInt value = cubicles.stream().filter(cube -> cube.getMyBracket() != null).mapToInt(cube -> cube.getMyBracket().getInt("\u8d27\u54c1\u4ef6\u6570")).max();
        this.maxPackNumber = value.isPresent() ? value.getAsInt() : 0;
    }

    private void populateCargoFloors() {
        this.cargofloors.clear();
        this.sameCubicles.stream().filter(cube -> cube.getMyBracket() != null).forEach(cube -> {
            Integer num = this.cargofloors.get(cube.getFloor());
            num = num == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
            this.cargofloors.put(cube.getFloor(), num);
        });
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public Bracket getNewBracket() {
        return this.newBracket;
    }

    public void setNewBracket(Bracket newBracket) {
        this.newBracket = newBracket;
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u6dfb\u52a0 " + newBracket);
        }
    }

    public List<Stacker> getStackers() {
        return this.stackers;
    }

    public void setStackers(List<Stacker> stackers) {
        this.stackers = stackers;
        stackers.stream().map(stacker -> stacker.getMyGroup()).forEach(group -> this.groups.put((Group)group, 5));
    }

    public int getMaxPackNumber() {
        return this.maxPackNumber;
    }

    public void setMixing(boolean mixing) {
        this.mixing = mixing;
    }

    public void moveCar2Last(Cubicle myCube) {
        block4: {
            block3: {
                if (!myCube.getMyAlley().getDistrict().isStacker()) break block3;
                Stacker myStacker = myCube.getMyAlley().getStacker();
                for (int index = 0; index < this.stackers.size(); ++index) {
                    if (myStacker != this.stackers.get(index)) continue;
                    this.stackers.remove(index);
                    this.stackers.add(myStacker);
                    return;
                }
                break block4;
            }
            if (!myCube.getMyAlley().getDistrict().isShuttle()) break block4;
            List<Car> shuttles = myCube.getMyAlley().getDistrict().getCars();
            int index = 0;
            for (int count = 0; count < shuttles.size(); ++count) {
                if (myCube.getFloor() == shuttles.get(index).position()[2]) {
                    Car tmp = shuttles.remove(index);
                    shuttles.add(tmp);
                    continue;
                }
                ++index;
            }
        }
    }

    public StockType getCarType() {
        return this.carType;
    }

    public int isInFixedFloor(int floor) {
        if (this.fixedFloor.isEmpty()) {
            return 0;
        }
        int ret = -1;
        for (int i = 0; i < this.fixedFloor.size(); ++i) {
            if (this.fixedFloor.get(i) != floor) continue;
            ret = i;
            break;
        }
        return ret;
    }

    public void addFixedFloor(int floor) {
        this.fixedFloor.add(floor);
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u6dfb\u52a0\u56fa\u5b9a\u7684\u697c\u5c42 " + floor);
        }
    }

    public List<Integer> getFixedFloor() {
        return this.fixedFloor;
    }

    public Map<Integer, Integer> getCargofloors() {
        return this.cargofloors;
    }

    public void moveFixedFloor2Last(int floor) {
        for (int i = 0; i < this.fixedFloor.size(); ++i) {
            if (this.fixedFloor.get(i) != floor) continue;
            this.fixedFloor.remove(i);
            this.fixedFloor.add(floor);
            return;
        }
    }

    public int getFloorNumber() {
        return this.floorNumber;
    }

    public void setFloorNumber(int floorNumber) {
        this.floorNumber = floorNumber;
    }

    public void setStartCoord(int startX, int startY) {
        this.startX = startX;
        this.startY = startY;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public Map<Group, Integer> getGroups() {
        return this.groups;
    }

    public void addGroup(Group group, int level) {
        if (level < 0) {
            level = 0;
        } else if (level >= 10) {
            level = 9;
        }
        this.groups.put(group, level);
        if (LOG.isTraceEnabled()) {
            LOG.trace("\u6dfb\u52a0 " + group);
        }
    }

    public void addGroup(Group group) {
        this.addGroup(group, 5);
    }

    public int isInGroups(Group group) {
        if (this.groups.isEmpty()) {
            return 0;
        }
        Integer ret = this.groups.get(group);
        if (ret != null) {
            return ret;
        }
        return Integer.MAX_VALUE;
    }

    private void markMatchCubicles() {
        if (this.myDistrict == null) {
            return;
        }
        this.sameCubicles.clear();
        this.myDistrict.initCubicleSteps();
        HashSet<Cubicle> ret = new HashSet<Cubicle>();
        this.setSimilarCubicles(ret);
        Cubicle[] allcubes = this.myDistrict.getCubicles();
        IntStream.range(0, allcubes.length).forEach(i -> {
            Cubicle cubicle = allcubes[i];
            if (cubicle == null || !this.matchParams(cubicle)) {
                return;
            }
            cubicle.setDistanceSteps(0);
            ret.add(cubicle);
            if (this.equals(cubicle.getMyBracket())) {
                this.sameCubicles.add(cubicle);
            }
            int scale = 2;
            int rowL = Math.max(cubicle.getY() - scale, this.myDistrict.getMinY());
            int rowH = Math.min(cubicle.getY() + scale, this.myDistrict.getMaxY());
            int colL = Math.max(cubicle.getX() - scale, this.myDistrict.getMinX());
            int colH = Math.min(cubicle.getX() + scale, this.myDistrict.getMaxX());
            int hiL = Math.max(cubicle.getFloor() - scale, this.myDistrict.getMinZ());
            int hiH = Math.min(cubicle.getFloor() + scale, this.myDistrict.getMaxZ());
            ArrayList<Cubicle> tmpCubicles = new ArrayList<Cubicle>();
            for (int col = colL; col <= colH; ++col) {
                for (int row = rowL; row <= rowH; ++row) {
                    for (int floor = hiL; floor <= hiH; ++floor) {
                        tmpCubicles.add(this.myDistrict.getCubicle(col, row, floor));
                    }
                }
            }
            if (rowL - 1 >= this.myDistrict.getMinY()) {
                tmpCubicles.add(this.myDistrict.getCubicle(cubicle.getX(), rowL - 1, cubicle.getFloor()));
            }
            if (rowH + 1 <= this.myDistrict.getMaxY()) {
                tmpCubicles.add(this.myDistrict.getCubicle(cubicle.getX(), rowH + 1, cubicle.getFloor()));
            }
            if (colL - 1 >= this.myDistrict.getMinX()) {
                tmpCubicles.add(this.myDistrict.getCubicle(colL - 1, cubicle.getY(), cubicle.getFloor()));
            }
            if (colH + 1 <= this.myDistrict.getMaxX()) {
                tmpCubicles.add(this.myDistrict.getCubicle(colH + 1, cubicle.getY(), cubicle.getFloor()));
            }
            if (hiL - 1 >= this.myDistrict.getMinZ()) {
                tmpCubicles.add(this.myDistrict.getCubicle(cubicle.getX(), cubicle.getY(), hiL - 1));
            }
            if (hiH + 1 <= this.myDistrict.getMaxZ()) {
                tmpCubicles.add(this.myDistrict.getCubicle(cubicle.getX(), cubicle.getY(), hiH + 1));
            }
            tmpCubicles.stream().forEach(tmpCube -> {
                if (tmpCube == null || tmpCube == cubicle) {
                    return;
                }
                int distance = Math.abs(tmpCube.getX() - cubicle.getX()) + Math.abs(tmpCube.getY() - cubicle.getY()) + PolicyPosition.getZWeight(this.myDistrict) * Math.abs(tmpCube.getFloor() - cubicle.getFloor());
                tmpCube.setDistanceSteps(Math.min(distance, tmpCube.getDistanceSteps()));
            });
        });
    }

    private boolean matchParams(Cubicle cube) {
        Bracket myBracket = cube.getMyBracket();
        if (myBracket == null) {
            return false;
        }
        return this.compatibleWith(myBracket);
    }

    private Set<Cubicle> allMatchCubicles() {
        HashSet<Cubicle> ret = new HashSet<Cubicle>();
        List<District> districts = Warehouse.INST.getAllDistricts();
        districts.stream().filter(district -> district.getId().equals(this.getMyDistrict().getId())).forEach(district -> district.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cubicle -> {
            Bracket bracket = cubicle.getMyBracket();
            if (bracket == null) {
                return;
            }
            if (this.equals(bracket)) {
                ret.add((Cubicle)cubicle);
            }
        })));
        return ret;
    }

    public int getMyShelfWeight(String shelfId) {
        Integer myShelfWeight = this.shelfWeight.get(shelfId);
        if (myShelfWeight == null) {
            return -1;
        }
        return myShelfWeight;
    }

    private void calculateShelfWeight() {
        if (this.myDistrict == null) {
            return;
        }
        this.shelfWeight.clear();
        this.myDistrict.getAlleys().stream().forEach(alley -> alley.getMyCubicle().stream().forEach(cube -> {
            Integer myShelfWeight = this.shelfWeight.get(cube.getShelfId());
            if (myShelfWeight == null) {
                myShelfWeight = 0;
            }
            int weight = 0;
            if (cube.getMyBracket() != null) {
                weight = cube.getMyBracket().getInt("\u8d27\u7269\u8d28\u91cf");
            }
            this.shelfWeight.put(cube.getShelfId(), myShelfWeight + weight);
        }));
    }

    private void calculateStackersWithMyCargos() {
        if (this.myDistrict == null) {
            return;
        }
        this.stackersWithMyCargo.clear();
        this.similarCubicles.stream().forEach(cube -> {
            Stacker stacker = cube.getMyAlley().getStacker();
            if (stacker == null) {
                LOG.error("\u4e0d\u8be5\u53d1\u751f\u7684\u9519\u8bef\uff0c\u5e93\u4f4d " + cube + " \u6ca1\u6709\u5bf9\u5e94\u7684\u5806\u579b\u673a\uff01");
                return;
            }
            this.stackersWithMyCargo.add(stacker);
        });
    }

    private Cargo realCargo() {
        if (this.newBracket == null) {
            throw new StatusException("\u6b64\u53c2\u6570\u6ca1\u6709\u914d\u7f6e\u5165\u5e93\u7684\u8d27\u7269\u4fe1\u606f\uff01");
        }
        return this.newBracket;
    }

    @Override
    public String get(String name) {
        if (this.behavior == Behavior.moveOut) {
            return super.get(name);
        }
        return this.realCargo().get(name);
    }

    @Override
    public int getInt(String name) {
        if (this.behavior == Behavior.moveOut) {
            return super.getInt(name);
        }
        return this.realCargo().getInt(name);
    }

    @Override
    public CargoLabel getLabel(String name) {
        if (this.behavior == Behavior.moveOut) {
            return super.getLabel(name);
        }
        return this.realCargo().getLabel(name);
    }

    @Override
    public void set(String name, String value) {
        if (this.behavior == Behavior.moveOut) {
            super.set(name, value);
        } else {
            this.realCargo().set(name, value);
        }
    }

    @Override
    public void set(String name, int value) {
        if (this.behavior == Behavior.moveOut) {
            super.set(name, value);
        } else {
            this.realCargo().set(name, value);
        }
    }

    public StockSize getStockSize() {
        return this.stockSize;
    }

    public void setStockSize(StockSize stockSize) {
        this.stockSize = stockSize;
    }

    public boolean isMixSize() {
        return this.mixSize;
    }

    public void setMixSize(boolean mixSize) {
        this.mixSize = mixSize;
    }

    private void markEmptyCubiclesNumber() {
        if (this.myDistrict == null) {
            throw new StatusException("\u6ca1\u6709\u6307\u5b9a\u5e93\u533a\u4f5c\u4e3a\u521d\u59cb\u5316\u8d27\u7269\u53c2\u6570\uff01");
        }
        this.myDistrict.getCars().stream().map(stacker -> ((Stacker)stacker).getMyGroup()).forEach(group -> {
            HashMap<StockSize, Integer> emptyNumber = new HashMap<StockSize, Integer>();
            for (Alley alley : group.getAllAlleys()) {
                for (int index = 0; index < alley.getMyCubicle().size() && alley.getMyCubicle().get(index).getStatus() == StockStatus.empty; ++index) {
                    Integer count2 = (Integer)emptyNumber.get((Object)alley.getMyCubicle().get(index).getSize());
                    if (count2 == null) {
                        count2 = 0;
                    }
                    count2 = count2 + 1;
                    emptyNumber.put(alley.getMyCubicle().get(index).getSize(), count2);
                }
            }
            emptyNumber.forEach((size, count) -> group.setEmptyNumber((StockSize)((Object)((Object)size)), (int)count));
        });
    }

    public void addMission(int floor, int num) {
        this.missions.put(floor, num);
        if (num > this.maxMission) {
            this.maxMission = num;
        }
    }

    public int getMissionNumber(int floor) {
        Integer ret = this.missions.get(floor);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public int getMaxMission() {
        return this.maxMission;
    }

    @Override
    public void mixLabel(String name) {
        if (this.behavior == Behavior.moveOut) {
            super.mixLabel(name);
        } else {
            this.realCargo().mixLabel(name);
        }
    }

    @Override
    public void mixAllLabels() {
        if (this.behavior == Behavior.moveOut) {
            super.mixAllLabels();
        } else {
            this.realCargo().mixAllLabels();
        }
    }

    @Override
    public Collection<CargoLabel> getLabels() {
        if (this.behavior == Behavior.moveOut) {
            return super.getLabels();
        }
        return this.realCargo().getLabels();
    }

    @Override
    public void copyTo(Cargo cargo) {
        if (this.behavior == Behavior.moveOut) {
            super.copyTo(cargo);
        } else {
            this.realCargo().copyTo(cargo);
        }
    }

    @Override
    public boolean compatibleWith(Cargo cargo) {
        if (!this.mixing) {
            return this.equals(cargo);
        }
        if (this.behavior == Behavior.moveOut) {
            return super.compatibleWith(cargo);
        }
        return this.realCargo().compatibleWith(cargo);
    }

    @Override
    public void addExpectedValue(String label, String expectedValue) {
        if (this.behavior == Behavior.moveOut) {
            super.addExpectedValue(label, expectedValue);
        } else {
            this.realCargo().addExpectedValue(label, expectedValue);
        }
    }

    @Override
    public boolean equals(Object cargo) {
        if (this.behavior == Behavior.moveOut) {
            return super.equals(cargo);
        }
        return this.realCargo().equals(cargo);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.behavior) + "\u53c2\u6570 " + super.toString() + ", \u5e93\u533a\uff1a" + this.myDistrict + ", \u7c7b\u578b\uff1a" + (Object)((Object)this.carType) + "\u8d27\u7269\uff1a" + this.newBracket + "\n\u6700\u5927\u4ef6\u6570\uff1a" + this.maxPackNumber + ", \u9650\u5236\u7684\u5806\u579b\u673a\u6570\u91cf\uff1a" + this.limitedStackerNumber + ", \u5269\u4f59\u7684\u5165\u5e93\u8d27\u7269\u6258\u76d8\u6570\u91cf\uff1a" + this.leftCargoNumber + ", \u662f\u5426\u6df7\u8d27\uff1a" + this.mixing + "\n" + this.stackers.stream().map(stacker -> stacker.toString()).collect(Collectors.joining(", ", "\u6307\u5b9a\u7684\u5806\u579b\u673a\u5217\u8868\uff1a", "\n")) + this.stackersWithMyCargo.stream().map(car -> car.toString()).collect(Collectors.joining(", ", "\u5f53\u524d\u8d27\u7269\u6240\u5728\u7684\u5806\u579b\u673a\uff1a", "\n")) + this.shelfWeight.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ", "\u8d27\u67b6\u627f\u91cd\uff1a", "\n")) + this.groups.entrySet().stream().map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", ", "\u9650\u5236\u5206\u7ec4\u51fa\u5165\u5e93\uff1a", "\n")) + (this.floorNumber != -1 ? "\u9650\u5236\u6446\u653e\u7684\u697c\u5c42\u6570" + this.floorNumber : "") + this.fixedFloor.stream().map(num -> num.toString()).collect(Collectors.joining(", ", "\u56fa\u5b9a\u7684\u697c\u5c42\u53f7\uff1a", "\n")) + (this.startX != Integer.MIN_VALUE && this.startY != Integer.MIN_VALUE ? "\u8fd0\u8d27\u8d77\u70b9\u5750\u6807\uff1a" + this.startX + " " + this.startY : "") + "\n";
    }
}

