/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.utils;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConst {
    private static final Logger LOG = LoggerFactory.getLogger(StorageConst.class);
    public static double minimumRecommendedValue = 1.0E-20;
    public static final int ILLEGALVALUE = -1;
    public static final int ILLEGALVALUE2 = Integer.MAX_VALUE;
    public static final int ILLEGALVALUE3 = Integer.MIN_VALUE;
    public static final int MAXSTEPS = 10;
    public static int MinEmptyNumber = 3;
    public static int MaxBearing = 100000000;
    public static int MaxMixNumber = 2;
    public static int DefaultMinFloorNumber = 2;
    public static int DefaultBufferNumber = 1;
    private static Map<String, Integer> shelfBearing = new HashMap<String, Integer>();
    private static Map<String, Integer> emptyNumbers = new HashMap<String, Integer>();
    private static final double MINANGLE = 0.13962634015954636;
    public static int MaxEmptyCubeNumber = 5;

    private StorageConst() {
    }

    public static int getBearing(String shelfId) {
        Integer ret = shelfBearing.get(shelfId);
        return ret == null ? MaxBearing : ret;
    }

    public static void setBearing(String shelfId, int bearing) {
        shelfBearing.put(shelfId, bearing);
    }

    public static int getEmptyNumber(String groupName) {
        Integer ret = emptyNumbers.get(groupName);
        return ret == null ? MinEmptyNumber : ret;
    }

    public static void setEmptyNumber(String groupName, int number) {
        emptyNumbers.put(groupName, number);
    }

    public static double[][] covMatrix(double[] covVector) {
        double[][] ret = new double[covVector.length][];
        for (int col = 0; col < covVector.length; ++col) {
            ret[col] = new double[covVector.length];
            for (int row = 0; row < covVector.length; ++row) {
                ret[col][row] = covVector[col] * covVector[row];
            }
        }
        return ret;
    }

    public static double[] covDiagMatrix(double[] covVector) {
        double[] ret = new double[covVector.length];
        for (int col = 0; col < covVector.length; ++col) {
            ret[col] = Math.pow(covVector[col], 2.0);
        }
        return ret;
    }

    public static double normDistribution(double[][] inv, double det, double[] x) {
        double coefficient = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, x.length) * det);
        double exp = 0.0;
        for (int col = 0; col < x.length; ++col) {
            double temp = 0.0;
            for (int row = 0; row < x.length; ++row) {
                temp += inv[col][row] * x[row];
            }
            exp += temp * x[col];
        }
        return coefficient * Math.exp(exp *= -0.5);
    }

    public static double normDistribution(double[][] cov, double[] x) {
        double det = StorageConst.det(cov);
        double[][] inv = new double[cov.length][];
        for (int i = 0; i < inv.length; ++i) {
            inv[i] = new double[cov[i].length];
            System.arraycopy(cov[i], 0, inv[i], 0, inv[i].length);
        }
        StorageConst.mrinv(inv);
        return StorageConst.normDistribution(inv, det, x);
    }

    public static double indepNormDistribution(double[] inv, double det, double[] x) {
        double coefficient = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, x.length) * det);
        double exp = 0.0;
        for (int col = 0; col < x.length; ++col) {
            exp += Math.pow(x[col], 2.0) * inv[col];
        }
        return coefficient * Math.exp(exp *= -0.5);
    }

    public static double indepNormDistribution(double[] cov, double[] x) {
        double det = StorageConst.diagDet(cov);
        double[] inv = StorageConst.diagMrinv(cov);
        return StorageConst.indepNormDistribution(inv, det, x);
    }

    public static double[] diagMrinv(double[] matrix) {
        double[] ret = new double[matrix.length];
        for (int col = 0; col < matrix.length; ++col) {
            ret[col] = 1.0 / matrix[col];
        }
        return ret;
    }

    public static double diagDet(double[] matrix) {
        double ret = 1.0;
        for (int col = 0; col < matrix.length; ++col) {
            ret *= matrix[col];
        }
        return ret;
    }

    public static double calculateWeightedDelta(double delta, int level, double x) {
        return 0.1 + x * Math.tan((double)(10 - level) * 0.13962634015954636);
    }

    public static void mrinv(double[][] matrix) {
        int j;
        int i;
        int n = matrix.length;
        int[] p = new int[n];
        double[][] b = new double[n][n];
        for (i = 0; i < n; ++i) {
            p[i] = i;
            b[i][i] = 1.0;
        }
        for (int k = 0; k < n; ++k) {
            double temp;
            int col;
            double max = 0.0;
            int row = col = i;
            for (i = k; i < n; ++i) {
                for (j = k; j < n; ++j) {
                    temp = Math.abs(b[i][j]);
                    if (!(max < temp)) continue;
                    max = temp;
                    row = i;
                    col = j;
                }
            }
            if (row != k) {
                for (j = 0; j < n; ++j) {
                    temp = matrix[row][j];
                    matrix[row][j] = matrix[k][j];
                    matrix[k][j] = temp;
                    temp = b[row][j];
                    b[row][j] = b[k][j];
                    b[k][j] = temp;
                }
                i = p[row];
                p[row] = p[k];
                p[k] = i;
            }
            if (col != k) {
                for (i = 0; i < n; ++i) {
                    temp = matrix[i][col];
                    matrix[i][col] = matrix[i][k];
                    matrix[i][k] = temp;
                }
            }
            j = k + 1;
            while (j < n) {
                double[] dArray = matrix[k];
                int n2 = j++;
                dArray[n2] = dArray[n2] / matrix[k][k];
            }
            j = 0;
            while (j < n) {
                double[] dArray = b[k];
                int n3 = j++;
                dArray[n3] = dArray[n3] / matrix[k][k];
            }
            matrix[k][k] = 1.0;
            for (j = k + 1; j < n; ++j) {
                for (i = 0; i < k; ++i) {
                    double[] dArray = matrix[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - matrix[i][k] * matrix[k][j];
                }
                for (i = k + 1; i < n; ++i) {
                    double[] dArray = matrix[i];
                    int n5 = j;
                    dArray[n5] = dArray[n5] - matrix[i][k] * matrix[k][j];
                }
            }
            for (j = 0; j < n; ++j) {
                for (i = 0; i < k; ++i) {
                    double[] dArray = b[i];
                    int n6 = j;
                    dArray[n6] = dArray[n6] - matrix[i][k] * b[k][j];
                }
                for (i = k + 1; i < n; ++i) {
                    double[] dArray = b[i];
                    int n7 = j;
                    dArray[n7] = dArray[n7] - matrix[i][k] * b[k][j];
                }
            }
            for (i = 0; i < k; ++i) {
                matrix[i][k] = 0.0;
            }
            matrix[k][k] = 1.0;
        }
        for (j = 0; j < n; ++j) {
            for (i = 0; i < n; ++i) {
                matrix[p[i]][j] = b[i][j];
            }
        }
    }

    private static double[][] A(double[][] matrix, int row, int column) {
        int j;
        int i;
        double[][] ans = new double[matrix.length - 1][matrix.length - 1];
        double[] temp = new double[(matrix.length - 1) * (matrix.length - 1)];
        int k = 0;
        for (i = 0; i < matrix.length; ++i) {
            for (j = 0; j < matrix[i].length; ++j) {
                if (i == row - 1 || j == column - 1) continue;
                temp[k++] = matrix[i][j];
            }
        }
        k = 0;
        for (i = 0; i < ans.length; ++i) {
            for (j = 0; j < ans[i].length; ++j) {
                ans[i][j] = temp[k++];
            }
        }
        return ans;
    }

    public static double det(double[][] matrix) {
        if (matrix.length == 1) {
            return matrix[0][0];
        }
        double ret = 0.0;
        for (int i = 0; i < matrix.length; ++i) {
            ret += matrix[i][0] * (double)((int)Math.pow(-1.0, i)) * StorageConst.det(StorageConst.A(matrix, i + 1, 1));
        }
        return ret;
    }

    public static void main(String[] args) {
        int i;
        int n = 15;
        int[][] x = new int[101][101];
        int row = 1;
        int col = n;
        int direction = 1;
        for (i = 1; i <= n * n; ++i) {
            x[row][col] = i;
            if (i == n * n) break;
            boolean loc = false;
            while (!loc) {
                if (direction % 4 == 1) {
                    if (row + 1 <= n && x[row + 1][col] == 0) {
                        ++row;
                        loc = true;
                    }
                } else if (direction % 4 == 2) {
                    if (col - 1 >= 1 && x[row][col - 1] == 0) {
                        --col;
                        loc = true;
                    }
                } else if (direction % 4 == 3) {
                    if (row - 1 >= 1 && x[row - 1][col] == 0) {
                        --row;
                        loc = true;
                    }
                } else if (col + 1 <= n && x[row][col + 1] == 0) {
                    ++col;
                    loc = true;
                }
                if (loc) continue;
                ++direction;
            }
        }
        for (i = 1; i <= n; ++i) {
            String l = "";
            for (int j = 1; j <= n; ++j) {
                l = l + x[i][j] + "\t";
            }
            System.out.println(l);
        }
    }
}

