/*
 * Decompiled with CFR 0.152.
 */
package com.wisdom.storalgorithm.utils.item;

import com.wisdom.storalgorithm.MainStorageAlgorithm;
import com.wisdom.storalgorithm.element.base.Label;
import com.wisdom.storalgorithm.element.base.StockStatus;
import com.wisdom.storalgorithm.element.cargo.Bracket;
import com.wisdom.storalgorithm.element.store.Cubicle;
import com.wisdom.storalgorithm.utils.CommonParams;
import com.wisdom.storalgorithm.utils.StorageConst;
import java.util.List;

public class CubicleSaver
implements Comparable<CubicleSaver> {
    private Cubicle cube;
    private int alleyIndex;
    private Bracket bracket;
    private StockStatus status;
    private double buff;

    public CubicleSaver(Cubicle cube) {
        this.cube = cube;
        this.bracket = cube.getMyBracket();
        this.status = cube.getStatus();
        for (int i = 0; i < cube.getMyAlley().getMyCubicle().size(); ++i) {
            if (cube.getMyAlley().getMyCubicle().get(i) != cube) continue;
            this.alleyIndex = i;
            break;
        }
    }

    public Cubicle getCube() {
        return this.cube;
    }

    public double getValue(CommonParams expectedParam, boolean readBuff) {
        if (readBuff) {
            return this.buff;
        }
        List<Label<?, ?>> labels = MainStorageAlgorithm.populateLabels(this.cube, expectedParam);
        this.cube.setRecommendedValue(MainStorageAlgorithm.getRecommendedValue(labels.toArray(new Label[0])));
        this.buff = this.cube.getRecommendedValue() < StorageConst.minimumRecommendedValue ? -1.0 : this.cube.getRecommendedValue();
        return this.buff;
    }

    public int getPackNumber() {
        String value = this.bracket.get("\u8d27\u54c1\u4ef6\u6570");
        if (value == null || value.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(value);
    }

    public void clear() {
        this.cube.setStatus(StockStatus.empty);
    }

    public void restore() {
        this.cube.setBracket(this.bracket);
        this.cube.setStatus(this.status);
    }

    @Override
    public int compareTo(CubicleSaver saver) {
        Integer myIndex = this.alleyIndex;
        return myIndex.compareTo(saver.alleyIndex);
    }
}

