/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.security.feign.aspect;

import com.zthz.security.feign.annoation.RequestShared;
import com.zthz.security.utils.RequestContextHolderUtils;
import com.zthz.security.utils.RequestTokenHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
public class RequestThreadAspect {
    private static final Logger logger = LoggerFactory.getLogger(RequestThreadAspect.class);

    @Pointcut(value="@annotation(com.zthz.security.feign.annoation.RequestShared)")
    public void pointCut() {
    }

    @Pointcut(value="@annotation(com.zthz.security.feign.annoation.RequestTokenShared)")
    public void requestTokenSharedPointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        RequestShared ta = method.getAnnotation(RequestShared.class);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5b50\u7ebf\u7a0b\u5171\u4eab\u7236\u7ebf\u7a0b\u4e0a\u7ebf\u6587:{}", (Object)ta.value());
        }
        if (ta.value()) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        }
        return point.proceed();
    }

    @Around(value="requestTokenSharedPointCut()")
    public Object requestTokenSharedAround(ProceedingJoinPoint point) throws Throwable {
        RequestTokenHolder.setToken(RequestContextHolderUtils.getRequest());
        return point.proceed();
    }
}

