/*
 * Decompiled with CFR 0.152.
 */
package com.zthz.security.feign.interceptor;

import com.zthz.security.utils.RequestTokenHolder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FeignBasicAuthRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(FeignBasicAuthRequestInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        Map<String, String> tokenMap;
        HttpServletRequest request;
        Enumeration headerNames;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (logger.isDebugEnabled()) {
            logger.debug("feign \u8bbe\u7f6e\u8bf7\u6c42\u5934");
        }
        requestTemplate.header("Z-Request-Way", new String[]{"zthz-feign"});
        if (null != attributes && (headerNames = (request = attributes.getRequest()).getHeaderNames()) != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String values = request.getHeader(name);
                requestTemplate.header(name, new String[]{values});
            }
        }
        if (null != (tokenMap = RequestTokenHolder.getToken())) {
            Map headers = requestTemplate.headers();
            tokenMap.keySet().forEach(item -> {
                if (!headers.containsKey(item)) {
                    requestTemplate.header(item, new String[]{(String)tokenMap.get(item)});
                }
            });
        }
        if (logger.isDebugEnabled()) {
            logger.debug("feign \u8bbe\u7f6e\u8bf7\u6c42\u5934\u5b8c\u6210");
        }
    }
}

