package com.zthzinfo.aliyun.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class OSSObject {
	private String accesskey;
	private String secret;
	private String host;
	private String baseHost;
	private String defaultBucket;

	public String getDefaultBucket() {
		return defaultBucket;
	}

	public void setDefaultBucket(String defaultBucket) {
		this.defaultBucket = defaultBucket;
	}

	public String getBaseHost() {
		return baseHost;
	}

	public void setBaseHost(String baseHost) {
		this.baseHost = baseHost;
	}

	public String getAccesskey() {
		return accesskey;
	}

	public void setAccesskey(String accesskey) {
		this.accesskey = accesskey;
		initClient();
	}

	public String getSecret() {
		return secret;
	}

	public void setSecret(String secret) {
		this.secret = secret;
		initClient();
	}

	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
		initClient();
	}

	public OSSClient getOssClient() {
		return ossClient;
	}

	public OSSObject() {}
	public OSSObject(String accesskey, String secret, String host) {
		this.accesskey = accesskey;
		this.secret = secret;
		this.host = host;
		initClient();
	}

	public OSSClient initClient() {
		if (ossClient == null) {
			synchronized (OSSObject.class) {
				if (ossClient == null) {
					if (accesskey != null && secret != null && host != null) {
						ossClient = new OSSClient(host,accesskey, secret);
					}
				}
			}
		}
		return ossClient;
	}

	private OSSClient ossClient = null;


	/**
	 * 获取素材完整路径
	 * @param key
	 * @param bucket
	 * @return
	 */
	public String getUrl(String key, String bucket) {
		return String.format("http://%s.%s/%s", (bucket==null?defaultBucket:bucket), baseHost, key);
	}

	/**
	 * 获取素材完整路径4https
	 * @param key
	 * @param bucket
	 * @return
	 */
	public String getUrl4Https(String key, String bucket) {
		return String.format("https://%s.%s/%s", (bucket==null?defaultBucket:bucket), baseHost, key);
	}


	/**
	 * 上传文件到oss
	 * @param key
	 * @param length
	 * @param in
	 * @param bucket
	 * @return key
	 * @throws OSSException
	 * @throws ClientException
	 * @throws FileNotFoundException
	 */
	public ResultFile uploadFileInputStream(String key, Long length , InputStream in, String bucket) {
		return uploadFileInputStream(key, length, in, bucket, "");
	}

	/**
	 * 上传文件到oss
	 * @param key
	 * @param length
	 * @param in
	 * @param bucket
	 * @param fileName 设置下载时的文件名称
	 * @return key
	 * @throws OSSException
	 * @throws ClientException
	 * @throws FileNotFoundException
	 */
	public ResultFile uploadFileInputStream(String key, Long length , InputStream in, String bucket, String fileName) {
		ObjectMetadata objectMeta = new ObjectMetadata();
		objectMeta.setContentLength(length);
		if (fileName != null && !"".equals(fileName == null ? "" : fileName.trim())) {
			objectMeta.setContentDisposition("attachment;filename=\""+fileName+"\"");
		}
		new HashMap<String,String>();
		ossClient.putObject(bucket==null?defaultBucket:bucket, key , in, objectMeta);

		ResultFile resultFile = new ResultFile(bucket==null?defaultBucket:bucket, key);
		resultFile.setUrl(this.getUrl(key, bucket==null?defaultBucket:bucket));
		resultFile.setUrlHttps(this.getUrl4Https(key, bucket==null?defaultBucket:bucket));

		return resultFile;
	}

	public String uploadFileByUrl(String bucket, String key, String url) throws IOException {
		InputStream inputStream = new URL(url).openStream();
		ossClient.putObject(bucket==null?defaultBucket:bucket, key, inputStream);
		return key;
	}

	public ResultFile uploadFileByMultipartFile(String key, MultipartFile file, String bucket) throws IOException {
		if (file==null){
			return null;
		}

		String ext = ExtUtil.getExtname(file);

		long length = file.getSize();

		ResultFile result = uploadFileInputStream((key == null ? UUID.randomUUID().toString().replaceAll("\\-", "")+ext : key), length, file.getInputStream(), bucket, file.getOriginalFilename());

		file.getInputStream().close();
		return result;
	}


	public List<String> getChildFolders(String bucket, String currentFolder){
		List<String> folders = new ArrayList<String>();
		// 构造ListObjectsRequest请求
		ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket==null?defaultBucket:bucket);
		listObjectsRequest.setDelimiter("/");
		if (currentFolder.startsWith("/")) {
			listObjectsRequest.setPrefix(currentFolder.substring(1));
		} else {
			listObjectsRequest.setPrefix(currentFolder);
		}

		ObjectListing listing = ossClient.listObjects(listObjectsRequest);
		for (String commonPrefix : listing.getCommonPrefixes()) {
			folders.add(commonPrefix.replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"));
		}
		return folders;
	}
	public List<OSSFile> getChildFiles(String bucket,String currentFolder){
		List<OSSFile> files = new ArrayList<OSSFile>();
		// 构造ListObjectsRequest请求
		ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket==null?defaultBucket:bucket);
// "/" 为文件夹的分隔符
		listObjectsRequest.setDelimiter("/");
// 列出fun目录下的所有文件和文件夹
		listObjectsRequest.setPrefix(currentFolder.substring(1));
		ObjectListing listing = ossClient.listObjects(listObjectsRequest);
// 遍历所有Object
		for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
			if (currentFolder.substring(1).equals(objectSummary.getKey()) && objectSummary.getSize() == 0) {
				continue;
			}
			Long size = null;
			files.add(new OSSFile(objectSummary.getKey().replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"), objectSummary.getLastModified(), objectSummary.getSize()));
		}
		return files;
	}
	public Boolean createFolder(String bucket,String newFolder){
		boolean found = ossClient.doesObjectExist(bucket==null?defaultBucket:bucket, newFolder);
		if (!found){
			ossClient.putObject(bucket==null?defaultBucket:bucket, newFolder, new ByteArrayInputStream(new byte[0]));
		}
		return true;
	}
	public Boolean uploadFile(String bucket,String key,InputStream inputStream){
		ossClient.putObject(bucket==null?defaultBucket:bucket, key, inputStream);
		return true;
	}
	public Boolean renameFile(String bucket,String fromKey,String toKey){
		CopyObjectResult result = ossClient.copyObject(bucket==null?defaultBucket:bucket,fromKey,bucket,toKey);
		delFile(bucket,fromKey);
		return true;
	}
	public Boolean isExists(String bucket,String key){
		return ossClient.doesObjectExist(bucket==null?defaultBucket:bucket, key);
	}
	public Boolean delFile(String bucket,String key){
		if (isExists(bucket==null?defaultBucket:bucket, key)){
			ossClient.deleteObject(bucket==null?defaultBucket:bucket, key);
		}
		return true;
	}
}
