/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.aliyun.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.zthzinfo.aliyun.oss.ExtUtil;
import com.zthzinfo.aliyun.oss.OSSFile;
import com.zthzinfo.aliyun.oss.ResultFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

public class OSSObject {
    private String accesskey;
    private String secret;
    private String host;
    private String baseHost;
    private String defaultBucket;
    private OSSClient ossClient = null;

    public String getBaseHost() {
        return this.baseHost;
    }

    public void setBaseHost(String baseHost) {
        this.baseHost = baseHost;
    }

    public String getAccesskey() {
        return this.accesskey;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
        this.initClient();
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.initClient();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.initClient();
    }

    public OSSClient getOssClient() {
        return this.ossClient;
    }

    public OSSObject() {
    }

    public OSSObject(String accesskey, String secret, String host) {
        this.accesskey = accesskey;
        this.secret = secret;
        this.host = host;
        this.initClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OSSClient initClient() {
        if (this.ossClient != null) return this.ossClient;
        Class<OSSObject> clazz = OSSObject.class;
        synchronized (OSSObject.class) {
            if (this.ossClient != null || this.accesskey == null || this.secret == null || this.host == null) return this.ossClient;
            this.ossClient = new OSSClient(this.host, this.accesskey, this.secret);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ossClient;
        }
    }

    public String getUrl(String key, String bucket) {
        return String.format("http://%s.%s/%s", bucket == null ? this.defaultBucket : bucket, this.baseHost, key);
    }

    public String getUrl4Https(String key, String bucket) {
        return String.format("https://%s.%s/%s", bucket == null ? this.defaultBucket : bucket, this.baseHost, key);
    }

    public ResultFile uploadFileInputStream(String key, Long length, InputStream in, String bucket) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(length.longValue());
        new HashMap();
        this.ossClient.putObject(bucket == null ? this.defaultBucket : bucket, key, in, objectMeta);
        ResultFile resultFile = new ResultFile(bucket == null ? this.defaultBucket : bucket, key);
        resultFile.setUrl(this.getUrl(key, bucket == null ? this.defaultBucket : bucket));
        resultFile.setUrlHttps(this.getUrl4Https(key, bucket == null ? this.defaultBucket : bucket));
        return resultFile;
    }

    public String uploadFileByUrl(String bucket, String key, String url) throws IOException {
        InputStream inputStream = new URL(url).openStream();
        this.ossClient.putObject(bucket == null ? this.defaultBucket : bucket, key, inputStream);
        return key;
    }

    public ResultFile uploadFileByMultipartFile(String key, MultipartFile file, String bucket) throws IOException {
        if (file == null) {
            return null;
        }
        String ext = ExtUtil.getExtname(file);
        long length = file.getSize();
        ResultFile result = this.uploadFileInputStream(key == null ? UUID.randomUUID().toString().replaceAll("\\-", "") + ext : key, length, file.getInputStream(), bucket);
        file.getInputStream().close();
        return result;
    }

    public List<String> getChildFolders(String bucket, String currentFolder) {
        ArrayList<String> folders = new ArrayList<String>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket == null ? this.defaultBucket : bucket);
        listObjectsRequest.setDelimiter("/");
        if (currentFolder.startsWith("/")) {
            listObjectsRequest.setPrefix(currentFolder.substring(1));
        } else {
            listObjectsRequest.setPrefix(currentFolder);
        }
        ObjectListing listing = this.ossClient.listObjects(listObjectsRequest);
        for (String commonPrefix : listing.getCommonPrefixes()) {
            folders.add(commonPrefix.replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"));
        }
        return folders;
    }

    public List<OSSFile> getChildFiles(String bucket, String currentFolder) {
        ArrayList<OSSFile> files = new ArrayList<OSSFile>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucket == null ? this.defaultBucket : bucket);
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setPrefix(currentFolder.substring(1));
        ObjectListing listing = this.ossClient.listObjects(listObjectsRequest);
        for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
            if (currentFolder.substring(1).equals(objectSummary.getKey()) && objectSummary.getSize() == 0L) continue;
            Object size = null;
            files.add(new OSSFile(objectSummary.getKey().replaceAll("/$", "").replaceAll("^.*/([^/]*)$", "$1"), objectSummary.getLastModified(), objectSummary.getSize()));
        }
        return files;
    }

    public Boolean createFolder(String bucket, String newFolder) {
        boolean found = this.ossClient.doesObjectExist(bucket == null ? this.defaultBucket : bucket, newFolder);
        if (!found) {
            this.ossClient.putObject(bucket == null ? this.defaultBucket : bucket, newFolder, (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return true;
    }

    public Boolean uploadFile(String bucket, String key, InputStream inputStream) {
        this.ossClient.putObject(bucket == null ? this.defaultBucket : bucket, key, inputStream);
        return true;
    }

    public Boolean renameFile(String bucket, String fromKey, String toKey) {
        CopyObjectResult result = this.ossClient.copyObject(bucket == null ? this.defaultBucket : bucket, fromKey, bucket, toKey);
        this.delFile(bucket, fromKey);
        return true;
    }

    public Boolean isExists(String bucket, String key) {
        return this.ossClient.doesObjectExist(bucket == null ? this.defaultBucket : bucket, key);
    }

    public Boolean delFile(String bucket, String key) {
        if (this.isExists(bucket == null ? this.defaultBucket : bucket, key).booleanValue()) {
            this.ossClient.deleteObject(bucket == null ? this.defaultBucket : bucket, key);
        }
        return true;
    }
}

