package com.zthzinfo.cluster;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;


public class AOPClusterLockForMethod {
	public static final String PREFIX_KEY = "CLSTLOCK";


	@Autowired(required = false)
	StringRedisTemplate template;

	Logger logger = LoggerFactory.getLogger(this.getClass());

	@Pointcut("@annotation(com.zthzinfo.cluster.ClusterMethodLock)")
	public void clusterLockPointCut() {

	}
	private String getKey(ProceedingJoinPoint joinPoint, ClusterMethodLock methodLock) {
		if (methodLock.value() != null && methodLock.value().trim().length() > 0) {
			return String.format("%s_%s", PREFIX_KEY, methodLock.value());
		}

		return String.format("%s_%s.%s", PREFIX_KEY, joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName());
	}

	@Around("clusterLockPointCut() && @annotation(methodLock)")
	public void aroundExec(ProceedingJoinPoint joinPoint, ClusterMethodLock methodLock) throws Throwable {
		if (template == null) {
			logger.info("未配置RedisTemplate");
			return;
		}

		String key = getKey(joinPoint, methodLock);
		RedisLock lock = new RedisLock(template, key);

		try {
			if (!lock.lock()) {
				logger.info(String.format("集群环境，该方法已被其他节点执行[%s]", key));
				return;
			}
			joinPoint.proceed();
		} catch (Throwable throwable) {
			throwable.printStackTrace();
			throw throwable;
		} finally {
			lock.unlock();
		}

	}

}
