/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.itextpdf.text.Document;
import com.zthzinfo.aliyun.oss.OSSObject;
import com.zthzinfo.aliyun.oss.ResultFile;
import com.zthzinfo.contract.enums.ShareTypeEnums;
import com.zthzinfo.contract.handler.IContractFileExchange;
import com.zthzinfo.contract.model.dto.FileParams;
import com.zthzinfo.contract.utils.MockMultipartFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractFileExchange<T>
implements IContractFileExchange {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileExchange.class);
    @Resource
    Environment environment;
    @Resource
    OSSObject ossObject;

    /*
     * Exception decompiling
     */
    @Override
    public String exchange(FileParams fileParam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getTmpFilePath(String module) {
        return new StringJoiner(File.separator).add(System.getProperty("java.io.tmpdir")).add(StrUtil.blankToDefault((CharSequence)this.environment.getProperty("spring.application.name"), (String)"base-service")).add(module).toString();
    }

    protected String upload(File tmpPdfFile, String tmpFilePath, FileParams fileParam) throws IOException {
        if (ShareTypeEnums.PDF.getKey().equals(fileParam.getType())) {
            return this.uploadPDF(tmpPdfFile, fileParam.getModule());
        }
        if (ShareTypeEnums.IMAGE.getKey().equals(fileParam.getType())) {
            return this.uploadImage(tmpPdfFile, tmpFilePath, fileParam);
        }
        throw new IllegalArgumentException("\u9519\u8bef\u7684\u5206\u4eab\u7c7b\u578b\uff1a" + fileParam.getType());
    }

    private String uploadPDF(File tmpPdfFile, String module) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(tmpPdfFile);){
            String string = this.uploadFileToOSS(fileInputStream, ".pdf", "application/pdf", module);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadImage(File tmpPdfFile, String tmpFilePath, FileParams fileParam) throws IOException {
        try (PDDocument tmpDoc = PDDocument.load((File)tmpPdfFile);){
            PDFRenderer renderer = new PDFRenderer(tmpDoc);
            int pages = tmpDoc.getNumberOfPages();
            List<Object> images = new ArrayList<BufferedImage>();
            if (pages < 2) {
                images.add(this.getSingleImageFile(renderer));
            } else if (fileParam.isGenLongImageFile()) {
                images.add(this.getLongImageFile(renderer, pages));
            } else {
                images = this.getMultiImages(renderer, pages);
            }
            StringJoiner resultSj = new StringJoiner("|");
            for (BufferedImage bufferedImage : images) {
                String tmpImageFilePath = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{tmpFilePath, File.separator, this.genFileName(), ".png"});
                File tmpImageFile = new File(tmpImageFilePath);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", tmpImageFile);
                try {
                    FileInputStream imgFIS = new FileInputStream(tmpImageFile);
                    Throwable throwable = null;
                    try {
                        String imgUrl = this.uploadFileToOSS(imgFIS, ".png", "image/png", fileParam.getModule());
                        resultSj.add(imgUrl);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (imgFIS == null) continue;
                        if (throwable != null) {
                            try {
                                imgFIS.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        imgFIS.close();
                    }
                }
                finally {
                    try {
                        FileUtil.del((File)tmpImageFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            String string = resultSj.toString();
            return string;
        }
    }

    private String genFileName() {
        return IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr();
    }

    private BufferedImage getSingleImageFile(PDFRenderer renderer) throws IOException {
        return renderer.renderImage(0, 2.0f);
    }

    private BufferedImage getLongImageFile(PDFRenderer renderer, int pages) throws IOException {
        int width = 0;
        int shiftHeight = 0;
        BufferedImage imageResult = null;
        for (int i = 0; i < pages; ++i) {
            BufferedImage image = renderer.renderImage(i, 2.0f);
            int imageHeight = image.getHeight();
            int imageWidth = image.getWidth();
            if (i == 0) {
                width = imageWidth;
                imageResult = new BufferedImage(width, imageHeight * pages, 1);
            } else {
                shiftHeight += imageHeight;
            }
            int[] singleImgRGB = image.getRGB(0, 0, width, imageHeight, null, 0, width);
            imageResult.setRGB(0, shiftHeight, width, imageHeight, singleImgRGB, 0, width);
        }
        return imageResult;
    }

    private List<BufferedImage> getMultiImages(PDFRenderer renderer, int pages) throws IOException {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (int i = 0; i < pages; ++i) {
            images.add(renderer.renderImage(i, 1.0f));
        }
        return images;
    }

    private String uploadFileToOSS(FileInputStream fileInputStream, String ext, String contentType, String module) throws IOException {
        String fileName = this.genFileName();
        String ossKey = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{module, "/", fileName, ext});
        MockMultipartFile multipartFile = new MockMultipartFile(fileName, fileName, contentType, fileInputStream);
        ResultFile resultFile = this.ossObject.uploadFileByMultipartFile(ossKey, (MultipartFile)multipartFile, null);
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230OSS,url={} ", (Object)resultFile.getUrl());
        return resultFile.getUrlHttps();
    }

    protected abstract T getData(String var1);

    protected abstract void assembleDocument(Document var1, T var2, boolean var3, String var4) throws Exception;
}

