/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.collection.CollUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.pdf.PdfPTable;
import com.zthzinfo.contract.enums.ContractTypeEnums;
import com.zthzinfo.contract.handler.exchange.AbstractBusinessContractExchange;
import com.zthzinfo.contract.model.dto.ContractClausesFormDTO;
import org.springframework.stereotype.Component;

@Component
public class SanhuoChuzuYunshuExchange
extends AbstractBusinessContractExchange {
    @Override
    public boolean support(Integer type) {
        return type.intValue() == ContractTypeEnums.SANHUO_CHUZU_YUNSHU.getKey();
    }

    @Override
    protected void shipTable(Document document, Font font, ContractClausesFormDTO dto) throws DocumentException {
        this.basicShipTable(document, font, dto, table -> {
            this.cellItem("\u8d27\u540d", (PdfPTable)table, font);
            this.cellItem("\u6258\u8fd0\u91cf", (PdfPTable)table, font, cell -> cell.setColspan(2));
            this.cellItem("\u5305\u88c5", (PdfPTable)table, font);
            this.cellItem("\u8fd0\u4ef7\uff08\u5143/\u5428\uff09", (PdfPTable)table, font);
            this.cellItem("\u5f00\u7968\u7c7b\u578b", (PdfPTable)table, font);
            this.cellItem("\u6700\u957f\u6ede\u671f", (PdfPTable)table, font);
            this.cellItem(dto.getGoodsName(), (PdfPTable)table, font);
            this.cellItem(dto.getGoodsWeight(), (PdfPTable)table, font, cell -> cell.setColspan(2));
            this.cellItem(dto.getPack(), (PdfPTable)table, font);
            this.cellItem(dto.getFreightRate(), (PdfPTable)table, font);
            this.cellItem(dto.getInvoiceType(), (PdfPTable)table, font);
            this.cellItem(dto.getLongestDemurrage(), (PdfPTable)table, font);
            if (CollUtil.isNotEmpty(dto.getShipPriceList())) {
                for (ContractClausesFormDTO.ShipPrice shipPrice : dto.getShipPriceList()) {
                    this.cellItem(shipPrice.getGoodsName(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getGoodsWeight(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getPack(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getFreightRate(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getInvoiceType(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getLongestDemurrage(), (PdfPTable)table, font);
                }
            }
        });
    }
}

