/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.zthzinfo.aliyun.oss.ExtUtil;
import com.zthzinfo.aliyun.oss.OSSObject;
import com.zthzinfo.aliyun.oss.ResultFile;
import com.zthzinfo.common.ResponseMapBuilder;
import com.zthzinfo.contract.domain.ContractChangeStatusLog;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.domain.TplContract;
import com.zthzinfo.contract.enums.ContractModuleEnums;
import com.zthzinfo.contract.enums.ContractSourceEnums;
import com.zthzinfo.contract.enums.ContractStatusEnums;
import com.zthzinfo.contract.enums.ContractTypeEnums;
import com.zthzinfo.contract.enums.ProcessStatusEnum;
import com.zthzinfo.contract.interfaceapi.IContractDataProvider;
import com.zthzinfo.contract.interfaceapi.vo.CtrtCompanyDto;
import com.zthzinfo.contract.interfaceapi.vo.CtrtContactDto;
import com.zthzinfo.contract.interfaceapi.vo.CtrtPageDto;
import com.zthzinfo.contract.model.dto.ContractDTO;
import com.zthzinfo.contract.model.dto.TplContractDTO;
import com.zthzinfo.contract.service.CtrtContractChangeStatusLogService;
import com.zthzinfo.contract.service.CtrtContractClausesService;
import com.zthzinfo.contract.service.CtrtContractService;
import com.zthzinfo.contract.service.CtrtIdGenService;
import com.zthzinfo.contract.service.CtrtTplContractClausesService;
import com.zthzinfo.contract.service.CtrtTplContractService;
import com.zthzinfo.contract.service.dto.CtrtContractQueryCriteria;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@RestController(value="ctrtContractController")
@Api(tags={"\u5408\u540c\u7ba1\u7406"})
@RequestMapping(value={"/ctrt-service"})
public class ContractController {
    private static final Logger log = LoggerFactory.getLogger(ContractController.class);
    public static final String VIEW_PRE = "ctrt-view";
    private final CtrtContractService ctrtContractService;
    private final CtrtContractClausesService clausesService;
    private final CtrtTplContractClausesService ctrtTplContractClausesService;
    private final CtrtTplContractService ctrtTplContractService;
    private final CtrtContractChangeStatusLogService contractChangeStatusLogService;
    private final CtrtIdGenService ctrtIdGenService;
    @Autowired(required=false)
    protected OSSObject ossObject;
    @Autowired(required=false)
    IContractDataProvider dataProvider;

    @RequestMapping(value={"/view/create"})
    public ModelAndView contract(@RequestParam(name="tplModules", required=false) List<Integer> tplModules) {
        Map<Integer, List<TplContractDTO>> templates = this.getContractTplByModule(tplModules);
        ModelAndView mv = new ModelAndView();
        mv.addObject("templates", templates);
        mv.addObject("step", (Object)0);
        mv.setViewName("ctrt-view/index");
        return mv;
    }

    @RequestMapping(value={"/view/modify"})
    public ModelAndView modify(@RequestParam(name="tplModules", required=false) List<Integer> tplModules, @RequestParam(value="contractId") String contractId) {
        Map<Integer, List<TplContractDTO>> templates = this.getContractTplByModule(tplModules);
        ContractDTO contract = this.ctrtContractService.selectById(contractId);
        ModelAndView mv = new ModelAndView();
        Assert.notNull((Object)contract, (String)"\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u8be5\u5408\u540c", (Object[])new Object[0]);
        mv.addObject("contractId", (Object)contractId);
        mv.addObject("entity", (Object)contract);
        mv.addObject("templates", templates);
        mv.addObject("step", (Object)0);
        mv.setViewName("ctrt-view/index");
        return mv;
    }

    @RequestMapping(value={"/getContactByCompanyId"})
    public ResponseEntity<Object> getContactByCompanyId(@RequestParam(value="companyIdA", required=false) String companyIdA, @RequestParam(value="companyIdB", required=false) String companyIdB, @RequestParam(value="currentRole") String currentRole) {
        if (this.dataProvider == null) {
            return new ResponseEntity(new Object(), HttpStatus.OK);
        }
        CtrtContactDto[] contactByCompanyId = this.dataProvider.getContactByCompanyId(companyIdA, companyIdB, currentRole);
        HashMap<String, CtrtContactDto> contactInMap = new HashMap<String, CtrtContactDto>();
        contactInMap.put("companyA", contactByCompanyId.length >= 1 ? contactByCompanyId[0] : null);
        contactInMap.put("companyB", contactByCompanyId.length >= 2 ? contactByCompanyId[1] : null);
        return new ResponseEntity(contactInMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/contactsByContactId"})
    public ResponseEntity<Object> contactsByContactId(@RequestParam(value="customerId") String customerId, @RequestParam(value="searchForRole") String searchForRole, @RequestParam(value="currentRole") String currentRole) {
        if (this.dataProvider == null) {
            return new ResponseEntity(new Object(), HttpStatus.OK);
        }
        List<CtrtContactDto> contactByCustomerId = this.dataProvider.contactByCustomerId(customerId, searchForRole, currentRole);
        return new ResponseEntity(contactByCustomerId, HttpStatus.OK);
    }

    @RequestMapping(value={"/partyChooseList"})
    public ResponseEntity<Object> partyChooseList(@RequestParam(value="page") Integer page, @RequestParam(value="size") Integer size, @RequestParam(name="keyword", required=false) String keyword, @RequestParam(value="searchForRole") String searchForRole, @RequestParam(value="currentRole") String currentRole) {
        if (this.dataProvider == null) {
            return new ResponseEntity(new ArrayList(), HttpStatus.OK);
        }
        CtrtPageDto<CtrtCompanyDto> pageDto = this.dataProvider.listCompanyForChoose(page, size, keyword, searchForRole, currentRole);
        return new ResponseEntity(pageDto, HttpStatus.OK);
    }

    @RequestMapping(value={"/accountList"})
    public ResponseEntity<Object> accountList(@RequestParam(value="id") String id, @RequestParam(value="searchForRole") String searchForRole, @RequestParam(value="currentRole") String currentRole) {
        if (this.dataProvider == null) {
            return new ResponseEntity(new ArrayList(), HttpStatus.OK);
        }
        return new ResponseEntity(this.dataProvider.accountList(id, searchForRole, currentRole), HttpStatus.OK);
    }

    @PostMapping(value={"/update_signdate"})
    public ResponseEntity<Object> updateSignDate(@RequestBody ContractDTO res) {
        String contractNo = this.ctrtContractService.updateSignDate(res);
        return new ResponseEntity((Object)contractNo, HttpStatus.OK);
    }

    private ModelAndView handleContractInfo(String contractId) {
        CtrtContract contract = (CtrtContract)this.ctrtContractService.getById((Serializable)((Object)contractId));
        Assert.notNull((Object)contract, (String)"\u7cfb\u7edf\u4e2d\u672a\u627e\u5230\u8be5\u5408\u540c", (Object[])new Object[0]);
        ContractDTO dto = new ContractDTO();
        BeanUtils.copyProperties((Object)contract, (Object)dto);
        dto.setContractTypeName(ContractTypeEnums.parseName(dto.getContractType()));
        dto.setSpStatusName(ProcessStatusEnum.getDescByKey(dto.getSpStatus()));
        ModelAndView mv = new ModelAndView();
        mv.addObject("info", (Object)dto);
        mv.setViewName("ctrt-viewinfo");
        return mv;
    }

    private List<Integer> moduleHandle(String source, Integer tplModule) {
        ArrayList tplModules = CollUtil.newArrayList((Object[])new Integer[0]);
        if (tplModule == null) {
            if (StrUtil.equals((CharSequence)source, (CharSequence)ContractSourceEnums.GANGCAI.getValue())) {
                tplModules.add(ContractModuleEnums.GANGCAI.getKey());
                tplModules.add(ContractModuleEnums.WULIU_OTHER.getKey());
            } else {
                tplModules.add(ContractModuleEnums.OTHER.getKey());
            }
        } else {
            tplModules.add(tplModule);
            if (StrUtil.equals((CharSequence)source, (CharSequence)ContractSourceEnums.GANGCAI.getValue())) {
                tplModules.add(ContractModuleEnums.WULIU_OTHER.getKey());
            }
        }
        return tplModules;
    }

    @GetMapping(value={"/genNo"})
    public ResponseEntity<Object> genNo(String companyCode, Integer contractType) {
        String number = this.ctrtIdGenService.genNumber(companyCode, "TEST", ContractTypeEnums.parse(contractType).getCode());
        return new ResponseEntity((Object)number, HttpStatus.OK);
    }

    @GetMapping(value={"/customer/list"})
    public ResponseEntity<Object> getCustomerList(@PageableDefault Pageable pageable) {
        return new ResponseEntity(new ArrayList(), HttpStatus.OK);
    }

    @GetMapping(value={"/statuslog"})
    public ResponseEntity<Object> getStatusLog(@RequestParam(value="id") String id) {
        return new ResponseEntity((Object)this.contractChangeStatusLogService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractChangeStatusLog::getContractId, (Object)id)).orderByAsc(ContractChangeStatusLog::getChangeTime)), HttpStatus.OK);
    }

    @GetMapping(value={"/me/list"})
    public ResponseEntity<Object> getMeCompanyList(@PageableDefault Pageable pageable) {
        return new ResponseEntity(new ArrayList(), HttpStatus.OK);
    }

    @GetMapping(value={"/tpl"})
    public Object getTplById(@RequestParam(value="tplId") String tplId) {
        return this.ctrtContractService.selectClausesByTplId(tplId);
    }

    @PostMapping(value={"/save"})
    public Object save(@RequestBody @Validated ContractDTO res) {
        this.ctrtContractService.saveEntity(res);
        return res;
    }

    @RequestMapping(value={"/upload"})
    public Object upload(@RequestParam(value="file") MultipartFile file) throws IOException {
        String fileName = IdUtil.getSnowflake((long)1L, (long)1L).nextIdStr();
        String ossKey = StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{"contract", "/", fileName, ExtUtil.getExtname((MultipartFile)file)});
        ResultFile resultFile = this.ossObject.uploadFileByMultipartFile(ossKey, file, null);
        log.info("\u4e0a\u4f20\u56fe\u7247\u5230\u4e91\u670d\u52a1\u5668\uff01url = " + resultFile.getUrlHttps());
        return ResponseMapBuilder.newBuilder().putSuccess().put("name", (Object)file.getOriginalFilename()).put("url", (Object)resultFile.getUrlHttps()).getResult();
    }

    private Map<Integer, List<TplContractDTO>> getContractTplByModule(List<Integer> modules) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (modules != null && modules.size() > 0) {
            queryWrapper.in(TplContract::getModule, modules);
        }
        return this.ctrtTplContractService.list((Wrapper)queryWrapper).stream().map(item -> {
            TplContractDTO dto = new TplContractDTO();
            BeanUtils.copyProperties((Object)item, (Object)dto);
            dto.setContractTypeName(ContractTypeEnums.parseName(item.getContractType()));
            dto.setContractTypeCode(Optional.ofNullable(ContractTypeEnums.parse(item.getContractType())).map(ContractTypeEnums::getCode).orElse(null));
            return dto;
        }).collect(Collectors.groupingBy(TplContract::getModule));
    }

    @GetMapping(value={"/download"})
    public void download(HttpServletResponse response, CtrtContractQueryCriteria criteria) throws IOException {
        this.ctrtContractService.download(this.ctrtContractService.queryAll(criteria), response);
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u5408\u540c")
    public ResponseEntity<Object> query(CtrtContractQueryCriteria criteria, Pageable pageable) {
        return new ResponseEntity(this.ctrtContractService.queryAll(criteria, pageable), HttpStatus.OK);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u5408\u540c")
    public ResponseEntity<Object> create(@Validated @RequestBody CtrtContract resources) {
        return new ResponseEntity((Object)this.ctrtContractService.save(resources), HttpStatus.CREATED);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u5408\u540c")
    public ResponseEntity<Object> update(@Validated @RequestBody CtrtContract resources) {
        this.ctrtContractService.updateById(resources);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @ApiOperation(value="\u5220\u9664\u5408\u540c")
    @DeleteMapping
    public ResponseEntity<Object> delete(@RequestBody String[] ids) {
        this.ctrtContractService.removeByIds(Arrays.asList(ids));
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/getContractByIds"})
    public ResponseEntity<Object> getContractByIds(@RequestParam(value="ids") String ids) {
        Assert.notBlank((CharSequence)ids);
        List contracts = this.ctrtContractService.listByIds(StrUtil.split((CharSequence)ids, (char)',', (int)-1));
        return new ResponseEntity((Object)contracts, HttpStatus.OK);
    }

    @PostMapping(value={"/invalid"})
    public ResponseEntity<Object> invalid(@RequestBody CtrtContract entity) {
        Assert.notBlank((CharSequence)entity.getId(), (String)"\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.ctrtContractService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper(CtrtContract.class).eq(CtrtContract::getId, (Object)entity.getId())).set(CtrtContract::getStatus, (Object)ContractStatusEnums.INVALID.getValue()));
        return new ResponseEntity(HttpStatus.OK);
    }

    public ContractController(CtrtContractService ctrtContractService, CtrtContractClausesService clausesService, CtrtTplContractClausesService ctrtTplContractClausesService, CtrtTplContractService ctrtTplContractService, CtrtContractChangeStatusLogService contractChangeStatusLogService, CtrtIdGenService ctrtIdGenService) {
        this.ctrtContractService = ctrtContractService;
        this.clausesService = clausesService;
        this.ctrtTplContractClausesService = ctrtTplContractClausesService;
        this.ctrtTplContractService = ctrtTplContractService;
        this.contractChangeStatusLogService = contractChangeStatusLogService;
        this.ctrtIdGenService = ctrtIdGenService;
    }
}

