/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.zthzinfo.contract.domain.ContractClauses;
import com.zthzinfo.contract.enums.ShareTypeEnums;
import com.zthzinfo.contract.handler.exchange.AbstractFileExchange;
import com.zthzinfo.contract.model.dto.ContractClausesFormDTO;
import com.zthzinfo.contract.model.dto.ContractDTO;
import com.zthzinfo.contract.service.CtrtContractService;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public abstract class AbstractBusinessContractExchange
extends AbstractFileExchange<ContractDTO> {
    @Resource
    CtrtContractService ctrtContractService;

    @Override
    protected ContractDTO getData(String id) {
        return this.ctrtContractService.selectById(id);
    }

    @Override
    protected void assembleDocument(Document document, ContractDTO data, boolean isDiffStandard, String shareTypeKey) throws Exception {
        List<ContractClauses> clausesBottoms;
        List<ContractClauses> clauses;
        ContractClausesFormDTO form = new ContractClausesFormDTO();
        if (StrUtil.isNotBlank((CharSequence)data.getClausesForm())) {
            form = (ContractClausesFormDTO)JSONObject.parseObject((String)StringEscapeUtils.unescapeJava((String)data.getClausesForm()), ContractClausesFormDTO.class);
        }
        BaseFont Chinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font font15 = new Font(Chinese, 15.0f, 1, BaseColor.BLACK);
        Font fontNormalBold = new Font(Chinese, 10.0f, 1, BaseColor.BLACK);
        Font fontNormal = new Font(Chinese, 10.0f, 0, BaseColor.BLACK);
        Font fontNormalRed = new Font(Chinese, 10.0f, 0, BaseColor.RED);
        BaseColor nonStandardColor = new BaseColor(255, 99, 71);
        Font fontNormalBoldNonStandard = new Font(Chinese, 10.0f, 1, nonStandardColor);
        Font fontNormalNonStandard = new Font(Chinese, 10.0f, 0, nonStandardColor);
        Paragraph blank = new Paragraph(" ");
        this.addParagraph(document, data.getContractTitle(), font15, 1);
        List<ContractClauses> clausesTops = data.getClausesTops();
        if (CollUtil.isNotEmpty(clausesTops)) {
            for (ContractClauses clausesTop : clausesTops) {
                boolean isSignDate = false;
                String tpl = clausesTop.getContent();
                String whiteStr = "consensusDate";
                String whiteSignStr = "signDate";
                if (StrUtil.contains((CharSequence)tpl, (CharSequence)whiteStr)) {
                    isSignDate = true;
                    tpl = new StringBuffer(tpl).insert(tpl.indexOf(whiteStr) + whiteStr.length(), ".toString()").toString();
                }
                if (StrUtil.contains((CharSequence)tpl, (CharSequence)whiteSignStr) && data.getSignDate() != null) {
                    isSignDate = true;
                    tpl = new StringBuffer(tpl).insert(tpl.indexOf(whiteSignStr) + whiteSignStr.length(), ".toString().substring(0,10)").toString();
                }
                String content = AbstractBusinessContractExchange.parseContent(data, tpl);
                if (isSignDate && shareTypeKey.equals(ShareTypeEnums.IMAGE.getKey()) && data.getConsensusDate() != null && data.getConsensusDate().isBefore(LocalDate.now())) {
                    this.addParagraph(document, clausesTop.getContentTitle(), content, fontNormalBold, fontNormalRed, 0);
                    continue;
                }
                this.addParagraph(document, clausesTop.getContentTitle(), content, fontNormalBold, fontNormal, 0);
            }
        }
        if (CollUtil.isNotEmpty(clauses = data.getClauses())) {
            for (int i = 0; i < clauses.size(); ++i) {
                ContractClauses item = clauses.get(i);
                String content = AbstractBusinessContractExchange.parseContent(form, item.getContent());
                if (item.getStandard().booleanValue() || !isDiffStandard) {
                    this.addParagraph(document, i + 1 + "." + Optional.ofNullable(item.getContentTitle()).orElse(""), content, fontNormalBold, fontNormal, 0);
                } else {
                    this.addParagraph(document, i + 1 + "." + Optional.ofNullable(item.getContentTitle()).orElse(""), content, fontNormalBoldNonStandard, fontNormalNonStandard, 0);
                }
                if (item.getShowTable() == null) continue;
                if (StrUtil.equals((CharSequence)item.getShowTable(), (CharSequence)"notice")) {
                    this.noticeTable(document, fontNormal, form);
                    continue;
                }
                this.shipTable(document, fontNormal, form);
            }
        }
        if (CollUtil.isNotEmpty(clausesBottoms = data.getClausesBottoms())) {
            for (ContractClauses item : clausesBottoms) {
                PdfPTable tableSignature = new PdfPTable(4);
                tableSignature.setWidthPercentage(100.0f);
                this.cellItem(item.getContentTitle(), tableSignature, fontNormal, cell -> {
                    cell.setIndent(24.0f);
                    cell.setBorderWidth(0.0f);
                    cell.setHorizontalAlignment(0);
                    cell.setColspan(3);
                });
                this.cellItem(item.getContent(), tableSignature, fontNormal, cell -> {
                    cell.setBorderWidth(0.0f);
                    cell.setHorizontalAlignment(0);
                });
                document.add((Element)tableSignature);
            }
        }
    }

    protected void shipTable(Document document, Font font, ContractClausesFormDTO dto) throws DocumentException {
        this.basicShipTable(document, font, dto, table -> {
            this.cellItem("\u8d27\u540d", (PdfPTable)table, font);
            this.cellItem("\u8d27\u91cd\uff08\u5428\uff09", (PdfPTable)table, font);
            this.cellItem("\u4ef6\u6570", (PdfPTable)table, font);
            this.cellItem("\u5305\u88c5", (PdfPTable)table, font);
            this.cellItem("\u6563\u6742\u4f53\u79ef(m\u00b3)", (PdfPTable)table, font);
            this.cellItem("\u8fd0\u4ef7\uff08\u5143/\u5428\uff09", (PdfPTable)table, font);
            this.cellItem("\u5f00\u7968\u7c7b\u578b", (PdfPTable)table, font);
            this.cellItem(dto.getGoodsName(), (PdfPTable)table, font);
            this.cellItem(dto.getGoodsWeight(), (PdfPTable)table, font);
            this.cellItem(dto.getQuantity(), (PdfPTable)table, font);
            this.cellItem(dto.getPack(), (PdfPTable)table, font);
            this.cellItem(dto.getBulkVolume(), (PdfPTable)table, font);
            this.cellItem(dto.getFreightRate(), (PdfPTable)table, font);
            this.cellItem(dto.getInvoiceType(), (PdfPTable)table, font);
            if (CollUtil.isNotEmpty(dto.getShipPriceList())) {
                for (ContractClausesFormDTO.ShipPrice shipPrice : dto.getShipPriceList()) {
                    this.cellItem(shipPrice.getGoodsName(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getGoodsWeight(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getQuantity(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getPack(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getBulkVolume(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getFreightRate(), (PdfPTable)table, font);
                    this.cellItem(shipPrice.getInvoiceType(), (PdfPTable)table, font);
                }
            }
        });
    }

    protected void noticeTable(Document document, Font font, ContractClausesFormDTO dto) throws DocumentException {
        PdfPTable table = new PdfPTable(8);
        table.setSpacingBefore(5.0f);
        table.setWidthPercentage(100.0f);
        this.cellItem("\u627f\u79df\u4eba\u786e\u8ba4\u8054\u7cfb\u65b9\u5f0f\u4e0e\u901a\u8baf\u5730\u5740", table, font, cell -> cell.setColspan(4));
        this.cellItem("\u51fa\u79df\u4eba\u786e\u8ba4\u8054\u7cfb\u65b9\u5f0f\u4e0e\u901a\u8baf\u5730\u5740", table, font, cell -> cell.setColspan(4));
        this.cellItem("\u4f20\u771f\u53f7", table, font);
        this.cellItem(dto.getLeaseeFaxno(), table, font);
        this.cellItem("\u90ae\u7bb1", table, font);
        this.cellItem(dto.getLeaseeEmail(), table, font);
        this.cellItem("\u4f20\u771f\u53f7", table, font);
        this.cellItem(dto.getLeaserFaxno(), table, font);
        this.cellItem("\u90ae\u7bb1", table, font);
        this.cellItem(dto.getLeaserEmail(), table, font);
        this.cellItem("\u5fae\u4fe1\u540d", table, font);
        this.cellItem(dto.getLeaseeWechatName(), table, font);
        this.cellItem("\u5fae\u4fe1\u53f7", table, font);
        this.cellItem(dto.getLeaseeWechatID(), table, font);
        this.cellItem("\u5fae\u4fe1\u540d", table, font);
        this.cellItem(dto.getLeaserWechatName(), table, font);
        this.cellItem("\u5fae\u4fe1\u53f7", table, font);
        this.cellItem(dto.getLeaserWechatName(), table, font);
        this.cellItem("\u5730\u5740\u53ca\u6536\u4ef6\u4eba", table, font);
        this.cellItem(dto.getLeaseeContact(), table, font, cell -> cell.setColspan(3));
        this.cellItem("\u5730\u5740\u53ca\u6536\u4ef6\u4eba", table, font);
        this.cellItem(dto.getLeaserContact(), table, font, cell -> cell.setColspan(3));
        document.add((Element)table);
    }

    protected void basicShipTable(Document document, Font font, ContractClausesFormDTO dto, Consumer<PdfPTable> consumer) throws DocumentException {
        this.basicShipTable(document, font, dto, table -> {
            this.cellItem("\u8ba2\u91d1(\u5143)", (PdfPTable)table, font);
            this.cellItem(dto.getDeposit(), (PdfPTable)table, font);
            this.cellItem("\u8ba2\u91d1\u652f\u4ed8\u65f6\u95f4", (PdfPTable)table, font);
            this.cellItem(Optional.ofNullable(dto.getDepositPayTime()).map(LocalDate::toString).map(item -> item + "\u524d").orElse(null), (PdfPTable)table, font);
            this.cellItem("\u6ede\u671f\u8d39\u7387(\u5143/\u5428\u5929)", (PdfPTable)table, font);
            this.cellItem(dto.getDemurrageRate(), (PdfPTable)table, font, cell -> cell.setColspan(2));
        }, consumer);
    }

    protected void basicShipTable(Document document, Font font, ContractClausesFormDTO dto, Consumer<PdfPTable> consumer1, Consumer<PdfPTable> consumer2) throws DocumentException {
        PdfPTable table = new PdfPTable(8);
        table.setSpacingBefore(5.0f);
        table.setTotalWidth(550.0f);
        table.setLockedWidth(true);
        float cellWidth = 75.0f;
        table.setWidths(new float[]{20.0f, cellWidth, cellWidth, cellWidth, cellWidth, cellWidth + 10.0f, cellWidth, cellWidth - 10.0f});
        table.setWidthPercentage(100.0f);
        this.cellItem("\u8239\u8236\u89c4\u8303", table, font, cell -> {
            cell.setRowspan(4);
            cell.setPaddingLeft(5.0f);
            cell.setPaddingRight(5.0f);
        });
        this.cellItem("\u8239\u540d", table, font);
        this.cellItem(dto.getShipName(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u8f7d\u91cd\u5428", table, font);
        this.cellItem(dto.getDeadWeight(), table, font);
        this.cellItem("\u957f/\u9ad8/\u5bbd(m)", table, font);
        this.cellItem(dto.getShipLengthHeightWidth(), table, font);
        this.cellItem("\u8239\u7c4d\u6e2f", table, font);
        this.cellItem(dto.getRegisterPort(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u603b\u5428/\u51c0\u5428", table, font);
        this.cellItem(dto.getTon(), table, font);
        this.cellItem("\u6ee1\u8f7d\u5403\u6c34(m)", table, font);
        this.cellItem(dto.getHeavyDraft(), table, font);
        this.cellItem("\u5efa\u9020\u65f6\u95f4", table, font);
        this.cellItem(dto.getBuildTime(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u603b\u8231\u5bb9(m\u00b3)", table, font);
        this.cellItem(dto.getHatchVolume(), table, font);
        this.cellItem("\u7a7a\u8f7d\u5403\u6c34(m)", table, font);
        this.cellItem(dto.getLightDraft(), table, font);
        this.cellItem("\u822a \u6b21", table, font);
        this.cellItem(dto.getVoyage(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u540a\u6746\u6570/\u8d1f\u8377", table, font);
        this.cellItem(dto.getDerrickNumber(), table, font);
        this.cellItem("\u8231\u53e3\u6570", table, font);
        this.cellItem(dto.getHatchCount(), table, font);
        int rs = dto.getShipPriceList() != null && dto.getShipPriceList().size() > 0 ? dto.getShipPriceList().size() : 0;
        this.cellItem("\u8d27\u8fd0\u7ea6\u5b9a", table, font, cell -> {
            cell.setRowspan(5 + rs);
            cell.setPaddingLeft(5.0f);
            cell.setPaddingRight(5.0f);
        });
        this.cellItem("\u8d77\u8fd0\u6e2f", table, font);
        this.cellItem(dto.getStartPort(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u76ee\u7684\u6e2f", table, font);
        this.cellItem(dto.getEndPort(), table, font, cell -> cell.setColspan(3));
        this.cellItem("\u53d7\u8f7d\u65e5\u671f", table, font);
        this.cellItem(dto.getPlanLoadingDate(), table, font, cell -> cell.setColspan(2));
        this.cellItem("\u62b5\u8fd0\u65e5\u671f", table, font);
        this.cellItem(dto.getArrivalDate(), table, font, cell -> cell.setColspan(3));
        consumer1.accept(table);
        consumer2.accept(table);
        document.add((Element)table);
    }

    public static <T> String parseContent(T dto, String tpl) {
        try {
            tpl = tpl.replaceAll("#\\{\\s*(\\w+)\\s*}", "#{$1?:' / '}");
            TemplateParserContext context = new TemplateParserContext();
            SpelExpressionParser parser = new SpelExpressionParser();
            Expression expression = parser.parseExpression(tpl, (ParserContext)context);
            return (String)expression.getValue(dto, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void addParagraph(Document document, String content, Font font, int alignment) throws DocumentException {
        this.addParagraph(document, null, content, null, font, alignment);
    }

    protected void addParagraph(Document document, String contentTitle, String content, Font titleFont, Font font, int alignment) throws DocumentException {
        Paragraph paragraph = new Paragraph();
        if (StrUtil.isNotBlank((CharSequence)contentTitle)) {
            Chunk chunkTitle = new Chunk(contentTitle, titleFont);
            paragraph.add((Element)chunkTitle);
        }
        if (StrUtil.isNotBlank((CharSequence)content)) {
            Chunk chunkContent = new Chunk(content, font);
            paragraph.add((Element)chunkContent);
        }
        paragraph.setAlignment(alignment);
        document.add((Element)paragraph);
    }

    protected void cellItem(Object value, PdfPTable table, Font font12) {
        this.cellItem(value, table, font12, cell -> {});
    }

    protected void cellItem(Object value, PdfPTable table, Font font12, Consumer<PdfPCell> consumer) {
        PdfPCell cell = new PdfPCell();
        cell.setMinimumHeight(20.0f);
        cell.setPhrase((Phrase)new Paragraph(Optional.ofNullable(value).map(String::valueOf).orElse("/"), font12));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        consumer.accept(cell);
        table.addCell(cell);
    }
}

