/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.handler.exchange;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.enums.ContractSourceEnums;
import com.zthzinfo.contract.handler.IContractProcessStatusExchange;
import com.zthzinfo.contract.model.dto.ContractProcessStatusParams;
import com.zthzinfo.contract.service.CtrtContractService;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GangcaiContractProcessStatusExchange
implements IContractProcessStatusExchange {
    private static final Logger log = LoggerFactory.getLogger(GangcaiContractProcessStatusExchange.class);
    @Resource
    CtrtContractService ctrtContractService;

    @Override
    public boolean support(String source) {
        return ContractSourceEnums.GANGCAI.getValue().equals(source);
    }

    @Override
    public void exchange(ContractProcessStatusParams params) {
        log.info("[\u901a\u77e5\u94a2\u6750\u4e1a\u52a1\u7cfb\u7edf]contractId={},spStatus={}", (Object)params.getContractId(), (Object)params.getSpStatus());
        CtrtContract contract = (CtrtContract)this.ctrtContractService.getById((Serializable)((Object)params.getContractId()));
        Assert.notNull((Object)contract);
        if (StrUtil.isBlank((CharSequence)contract.getProcessData())) {
            log.warn("[\u901a\u77e5\u94a2\u6750\u4e1a\u52a1\u7cfb\u7edf]\u56de\u8c03\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
            return;
        }
        JSONObject processData = null;
        try {
            processData = JSONObject.parseObject((String)contract.getProcessData());
        }
        catch (Exception e) {
            log.error("[\u901a\u77e5\u94a2\u6750\u4e1a\u52a1\u7cfb\u7edf]\u89e3\u6790processData\u5f02\u5e38\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
            e.printStackTrace();
            throw e;
        }
        String shipLineId = processData.getString("id");
        if (StrUtil.isBlank((CharSequence)shipLineId)) {
            log.error("[\u901a\u77e5\u94a2\u6750\u4e1a\u52a1\u7cfb\u7edf]\u672a\u89e3\u6790\u51fashipLineId\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
        }
    }
}

