/*
 * Decompiled with CFR 0.152.
 */
package com.zthzinfo.contract.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.zthzinfo.contract.base.BaseServiceImpl;
import com.zthzinfo.contract.base.QueryHelpPlus;
import com.zthzinfo.contract.domain.ContractClauses;
import com.zthzinfo.contract.domain.CtrtContract;
import com.zthzinfo.contract.domain.TplContract;
import com.zthzinfo.contract.domain.TplContractClauses;
import com.zthzinfo.contract.enums.ContractClausesTypeEnums;
import com.zthzinfo.contract.enums.ContractTypeEnums;
import com.zthzinfo.contract.enums.ProcessStatusEnum;
import com.zthzinfo.contract.enums.ShareTypeEnums;
import com.zthzinfo.contract.handler.dispatcher.ContractFileDispatcher;
import com.zthzinfo.contract.handler.dispatcher.ContractProcessGetChartererDispatcher;
import com.zthzinfo.contract.handler.dispatcher.ContractProcessStatusDispatcher;
import com.zthzinfo.contract.mapper.CtrtContractMapper;
import com.zthzinfo.contract.model.dto.ContractDTO;
import com.zthzinfo.contract.model.dto.ContractVo;
import com.zthzinfo.contract.model.dto.FileParams;
import com.zthzinfo.contract.service.CtrtContractClausesService;
import com.zthzinfo.contract.service.CtrtContractService;
import com.zthzinfo.contract.service.CtrtIdGenService;
import com.zthzinfo.contract.service.CtrtTplContractClausesService;
import com.zthzinfo.contract.service.CtrtTplContractService;
import com.zthzinfo.contract.service.dto.ContractDto;
import com.zthzinfo.contract.service.dto.CtrtContractQueryCriteria;
import com.zthzinfo.contract.service.mapstruct.ContractSMapper;
import com.zthzinfo.contract.utils.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CtrtContractServiceImpl
extends BaseServiceImpl<CtrtContractMapper, CtrtContract>
implements CtrtContractService {
    private static final Logger log = LoggerFactory.getLogger(CtrtContractServiceImpl.class);
    @Resource
    private ContractSMapper contractSMapper;
    @Resource
    private CtrtContractMapper ctrtContractMapper;
    @Resource
    CtrtContractClausesService clausesService;
    @Resource
    private CtrtTplContractClausesService ctrtTplContractClausesService;
    @Resource
    private CtrtTplContractService ctrtTplContractService;
    @Resource
    CtrtIdGenService ctrtIdGenService;
    @Resource
    ContractFileDispatcher contractFileDispatcher;
    @Resource
    ContractProcessStatusDispatcher contractProcessStatusDispatcher;
    @Resource
    ContractProcessGetChartererDispatcher contractProcessGetChartererDispatcher;

    @Override
    public Map<String, Object> queryAll(CtrtContractQueryCriteria criteria, Pageable pageable) {
        this.getPage(pageable);
        PageInfo page = new PageInfo(this.queryAll(criteria));
        return this.toMap(page);
    }

    @Override
    public List<ContractDto> queryAll(CtrtContractQueryCriteria criteria) {
        return this.listToDto(this.list((Wrapper)QueryHelpPlus.getPredicate(CtrtContract.class, criteria)), this.contractSMapper);
    }

    @Override
    public ContractDTO selectById(String id) {
        CtrtContract entity = (CtrtContract)this.getById((Serializable)((Object)id));
        Assert.notNull((Object)entity, (String)"\u672a\u627e\u5230\u8be5\u5408\u540c", (Object[])new Object[0]);
        ContractDTO dto = this.selectClauses(entity.getTplId());
        BeanUtils.copyProperties((Object)entity, (Object)dto);
        dto.setContractTypeName(ContractTypeEnums.parseName(entity.getContractType()));
        dto.setSpStatusName(ProcessStatusEnum.getDescByKey(entity.getSpStatus()));
        return dto;
    }

    private ContractDTO selectClauses(String tplId) {
        List clauses = this.ctrtTplContractClausesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TplContractClauses::getTplId, (Object)tplId)).orderByAsc(TplContractClauses::getSort)).stream().map(item -> {
            ContractClauses clause = new ContractClauses();
            clause.setContent(item.getContent());
            clause.setStandard(item.getStandard());
            clause.setTplClauseId(item.getId());
            clause.setEnableChange(item.getEnableChange());
            clause.setShowTable(item.getShowTable());
            clause.setContentTitle(item.getContentTitle());
            clause.setSort(item.getSort());
            clause.setClausesType(item.getClausesType());
            return clause;
        }).collect(Collectors.toList());
        Map<Integer, List<ContractClauses>> table = clauses.stream().collect(Collectors.groupingBy(ContractClauses::getClausesType));
        ContractDTO dto = new ContractDTO();
        dto.setClauses(Optional.ofNullable(table).map(item -> (List)item.get(ContractClausesTypeEnums.NORMAL.getKey())).orElse(new ArrayList()));
        dto.setClausesTops(Optional.ofNullable(table).map(item -> (List)item.get(ContractClausesTypeEnums.TOP.getKey())).orElse(new ArrayList()));
        dto.setClausesBottoms(Optional.ofNullable(table).map(item -> (List)item.get(ContractClausesTypeEnums.BOTTOM.getKey())).orElse(new ArrayList()));
        return dto;
    }

    @Override
    public ContractDTO selectClausesByTplId(String tplId) {
        ContractDTO dto = this.selectClauses(tplId);
        TplContract tpl = (TplContract)this.ctrtTplContractService.getById((Serializable)((Object)tplId));
        dto.setTplSchema(tpl.getFormSchema());
        dto.setContractType(tpl.getContractType());
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveEntity(ContractDTO res) {
        this.incrGenContractNo(res);
        this.contractFileUpload(res);
        if (StrUtil.isNotBlank((CharSequence)res.getId())) {
            this.clausesService.remove((Wrapper)new LambdaQueryWrapper().eq(ContractClauses::getContractId, (Object)res.getId()));
        }
        this.saveOrUpdate(res);
        List<Object> list = CollUtil.newArrayList((Object[])new ContractClauses[0]);
        if (CollUtil.isNotEmpty(res.getClausesTops())) {
            list.addAll(res.getClausesTops());
        }
        if (CollUtil.isNotEmpty(res.getClauses())) {
            list.addAll(res.getClauses());
        }
        if (CollUtil.isNotEmpty(res.getClausesBottoms())) {
            list.addAll(res.getClausesBottoms());
        }
        if (CollUtil.isEmpty((Collection)list)) {
            return;
        }
        if (CollUtil.isNotEmpty((Collection)(list = list.stream().peek(item -> {
            item.setId(null);
            item.setContractId(res.getId());
        }).collect(Collectors.toList())))) {
            this.clausesService.saveBatch(list);
        }
    }

    private void incrGenContractNo(ContractDTO res) {
        if (res.getSignDate() == null || StrUtil.isNotBlank((CharSequence)res.getContractNo())) {
            log.info("\u7b7e\u8ba2\u65e5\u671f\u4e3a\u7a7a\u6216\u8005\u5df2\u6709\u5408\u540c\u53f7\u4e0d\u8bbe\u7f6e\u5408\u540c\u53f7");
            return;
        }
        String contractNo = this.ctrtIdGenService.incrementAndGet(res.getContractNoFirstPrefix(), res.getContractNoSecondPrefix(), ContractTypeEnums.parse(res.getContractType()).getCode());
        res.setContractNo(contractNo);
    }

    private void contractFileUpload(ContractDTO res) {
        if (!res.getUseTpl().booleanValue()) {
            return;
        }
        FileParams fileParams = new FileParams();
        fileParams.setType(ShareTypeEnums.PDF.getKey());
        fileParams.setModule("contract");
        fileParams.setGenLongImageFile(true);
        fileParams.setUseData(true);
        fileParams.setData(res);
        fileParams.setDiffStandard(false);
        fileParams.setContractType(res.getContractType());
        String url = this.contractFileDispatcher.dispatch(fileParams);
        res.setFileUrl(url);
        res.setFileName(FileUtil.getName((String)url));
        fileParams.setType(ShareTypeEnums.IMAGE.getKey());
        fileParams.setDiffStandard(true);
        url = this.contractFileDispatcher.dispatch(fileParams);
        res.setPreviewFileUrl(url);
    }

    @Override
    public void download(List<ContractDto> dtos, HttpServletResponse response) throws IOException {
        ArrayList<ContractVo> voArrayList = new ArrayList<ContractVo>();
        for (int i = 0; i < dtos.size(); ++i) {
            ContractDto item = dtos.get(i);
            ContractVo vo = new ContractVo();
            vo.setNo(i + 1 + "");
            vo.setContractNo(item.getContractNo());
            vo.setSignDate(Optional.ofNullable(item.getSignDate()).map(sd -> sd.format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5"))).orElse(null));
            vo.setContractType(item.getContractTitle());
            vo.setPartyAName(BooleanUtil.toString((boolean)Optional.ofNullable(item.getMyIsPartyA()).orElse(true), (String)item.getPartyAName(), (String)item.getPartyBName()));
            vo.setPartyBName(BooleanUtil.toString((boolean)Optional.ofNullable(item.getMyIsPartyA()).orElse(true), (String)item.getPartyBName(), (String)item.getPartyAName()));
            voArrayList.add(vo);
        }
        voArrayList.add(new ContractVo("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "\u5ba1\u6838\uff08\u516c\u53f8/\u90e8\u95e8\u8d1f\u8d23\u4eba\uff09\uff1a", "", ""));
        voArrayList.add(new ContractVo("\u5907\u6ce8", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""));
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        headWriteCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.WHITE.getIndex()));
        WriteFont writeFont = new WriteFont();
        writeFont.setBold(Boolean.valueOf(false));
        writeFont.setFontHeightInPoints(Short.valueOf((short)11));
        headWriteCellStyle.setWriteFont(writeFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        try {
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ContractVo.class).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).head(this.head())).sheet("\u7edf\u8ba1\u62a5\u8868").doWrite(voArrayList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<List<String>> head() {
        ArrayList headTitles = CollUtil.newArrayList((Object[])new List[0]);
        String title = "\u516c\u53f8\u5408\u540c\u53f0\u8d26\u7ba1\u7406\u8868";
        String empty = "";
        String empty1 = " ";
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, "\u62a5\u9001\u90e8\u95e8/\u516c\u53f8\uff1a", "\u586b\u8868\u4eba\uff1a", "\u586b\u8868\u65e5\u671f\uff1a", "\u5e8f\u53f7", "\u5e8f\u53f7"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u7f16\u53f7", "\u5408\u540c\u7f16\u53f7"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u7b7e\u8ba2\u65e5\u671f", "\u7b7e\u8ba2\u65e5\u671f"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u7c7b\u578b", "\u7c7b\u578b"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u5f53\u4e8b\u4eba", "\u6211\u65b9\u5355\u4f4d"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u5f53\u4e8b\u4eba", "\u4ed6\u65b9\u5355\u4f4d"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u751f\u6548\u6761\u4ef6\u53ca\u65e5\u671f", "\u5408\u540c\u751f\u6548\u6761\u4ef6\u53ca\u65e5\u671f"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u6211\u65b9\u4e49\u52a1\u6982\u8ff0", "\u6211\u65b9\u4e49\u52a1\u6982\u8ff0"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u6807\u7684", "\u6807\u7684"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u6536\u4ed8\u65b9\u5f0f", "\u6536\u4ed8\u65b9\u5f0f"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u8ba2\u91d1\uff08\u9884\u4ed8\u6b3e\uff09", "\u8ba2\u91d1\uff08\u9884\u4ed8\u6b3e\uff09"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u603b\u4ef7\u6b3e", "\u5408\u540c\u603b\u4ef7\u6b3e"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u5c65\u884c\u60c5\u51b5", "\u5408\u540c\u5c65\u884c\u60c5\u51b5"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u662f\u5426\u5b58\u5728\u8fdd\u7ea6\u60c5\u5f62", "\u662f\u5426\u5b58\u5728\u8fdd\u7ea6\u60c5\u5f62"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u8fdd\u7ea6\u60c5\u5f62\u63cf\u8ff0", "\u8fdd\u7ea6\u60c5\u5f62\u63cf\u8ff0"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u8fdd\u7ea6\u8d23\u4efb\uff08\u8fdd\u7ea6\u91d1\uff09", "\u8fdd\u7ea6\u8d23\u4efb\uff08\u8fdd\u7ea6\u91d1\uff09"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5408\u540c\u4efd\u6570", "\u5408\u540c\u4efd\u6570"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u7b7e\u7ea6\u627f\u529e\u90e8\u95e8\u3001\u7ecf\u529e\u4eba\u3001\u8054\u7cfb\u65b9\u5f0f", "\u7b7e\u7ea6\u627f\u529e\u90e8\u95e8\u3001\u7ecf\u529e\u4eba\u3001\u8054\u7cfb\u65b9\u5f0f"}));
        headTitles.add(Lists.newArrayList((Object[])new String[]{title, empty, empty1, empty, "\u5907\u6ce8", "\u5907\u6ce8"}));
        return headTitles;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateSignDate(ContractDTO res) {
        this.incrGenContractNo(res);
        this.updateById(res);
        return res.getContractNo();
    }

    @Override
    public PageInfo<ContractDto> searchContract(CtrtContractQueryCriteria criteria, Pageable pageable) {
        this.getPage(pageable);
        PageInfo page = new PageInfo(this.queryAll(criteria));
        return page;
    }
}

