package com.zthzinfo.contract;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(ContractProperties.class)
@ConditionalOnProperty(prefix = "zthz.contract", name = "enabled", matchIfMissing = true)
@MapperScan("com.zthzinfo.contract.mapper")
@ComponentScan("com.zthzinfo.contract")
public class ContractAutoConfig {

}
