package com.zthzinfo.contract.base;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.data.domain.Pageable;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhaoeryu 2020/10/31
 */
public class BaseServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<M, T> implements BaseService<T> {

    protected void getPage(Pageable pageable) {
        getPage(pageable,true);
    }

    protected void getPage(Pageable pageable,boolean isOrder){
        if (isOrder){
            String order = null;
            if(pageable.getSort() != null){
                order = pageable.getSort().toString();
                order = order.replace(":"," ");
                if ("UNSORTED".equals(order)){
                    PageHelper.startPage(pageable.getPageNumber() + 1, pageable.getPageSize());
                    return;
                }
            }
            PageHelper.startPage(pageable.getPageNumber() + 1, pageable.getPageSize(),order);
        }else{
            PageHelper.startPage(pageable.getPageNumber() + 1, pageable.getPageSize());
        }
    }

    protected <C> Map<String,Object> toMap(PageInfo<C> page){
        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("content", page.getList());
        map.put("totalElements", page.getTotal());
        return map;
    }
    protected <C> Map<String,Object> toMap(List<C> list,long total){
        Map<String, Object> map = new LinkedHashMap<>(2);
        map.put("content", list);
        map.put("totalElements", total);
        return map;
    }

    /**
     * 解决 分页total的问题
     * 原因：分页返回的是Page转换成Dto时，是List，导致total的错误
     * @return
     */
    protected <D> List<D> listToDto(List<T> r, com.zthzinfo.contract.base.BaseMapper<D,T> baseMapper){
        Page<D> page = new Page<>();
        page.addAll(baseMapper.toDto(r));
        if (r instanceof Page){
            Page<T> rp = (Page) r;
            page.setTotal(rp.getTotal());
        }
        return page;
    }
}
