package com.zthzinfo.contract.domain;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 合同状态变更记录表(ContractChangeStatusLog)实体类
 *
 * @author zhaoey
 * @since 2022-01-27 10:46:44
 */
@Data
@TableName("ctrt_contract_change_status_log")
public class ContractChangeStatusLog implements Serializable {
    private static final long serialVersionUID = 315502405057798194L;

    @TableId
    private String id;

    /**
     * 合同ID
     */
    private String contractId;
    /**
     * 合同状态
     */
    private Integer status;
    /**
     * 状态变更时间
     */
    private Date changeTime;
    private Date createTime;
    private Date updateTime;
    @TableField(fill = FieldFill.INSERT)
    private String createBy;
    @TableField(fill = FieldFill.UPDATE)
    private String updateBy;
    @TableLogic
    private Integer delFlag;
    private String remark;

}
